/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.controller.dto.client.MemberClientFilteringListConfigDTO;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringService;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ClientFilteringBroadcaster
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientFilteringBroadcaster.class);
    private static final long DEFAULT_RESCHEDULE_DELAY_MS = 1000L;
    private static final long DEFAULT_RESCHEDULE_ON_ERROR_DELAY_MS = 5000L;
    private final ClientFilteringService clientFilteringService;
    private final long rescheduleDelayMs;
    private final long rescheduleOnErrorDelayMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, r -> new Thread(r, "ClientFilteringBroadcaster"));
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final MCClientManager mcClientManager;

    public ClientFilteringBroadcaster(ClientFilteringService clientFilteringService, MCClientManager mcClientManager) {
        this(clientFilteringService, 1000L, 5000L, mcClientManager);
    }

    ClientFilteringBroadcaster(ClientFilteringService clientFilteringService, long rescheduleDelayMs, long rescheduleOnErrorDelayMs, MCClientManager mcClientManager) {
        this.clientFilteringService = clientFilteringService;
        this.rescheduleDelayMs = rescheduleDelayMs;
        this.rescheduleOnErrorDelayMs = rescheduleOnErrorDelayMs;
        this.mcClientManager = mcClientManager;
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        String cluster = event.getCluster();
        MCClient client = this.mcClientManager.clientFor(cluster);
        event.getMembers().forEach(member -> this.scheduleNextBroadcast(this.nextChainId(member), client, member, 0L));
    }

    private void scheduleNextBroadcast(int chainId, MCClient client, Member member, long delayMs) {
        this.executor.schedule(() -> {
            try {
                this.runBroadcast(chainId, client, member);
            }
            catch (Exception e) {
                log.error("Unexpected error when broadcasting to {}.", (Object)member, (Object)e);
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    private void runBroadcast(int chainId, MCClient client, Member member) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        if (!this.clientFilteringService.hasLicensedFeature()) {
            this.scheduleNextBroadcast(chainId, client, member, this.rescheduleDelayMs);
            return;
        }
        String cluster = client.getClusterName();
        MemberClientFilteringListConfigDTO config = this.clientFilteringService.getDeployedForMembers(cluster);
        String eTag = config.getETag();
        ((CompletableFuture)client.matchMCConfig(member, eTag).thenComposeAsync(matchResult -> {
            if (!matchResult.booleanValue()) {
                log.info("Deploying client filtering config to {} in cluster {}.", (Object)member, (Object)cluster);
                return client.applyMCConfig(member, eTag, config.toHazelcastDTO());
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.executor)).whenCompleteAsync((v, t) -> {
            if (t == null) {
                this.scheduleNextBroadcast(chainId, client, member, this.rescheduleDelayMs);
                return;
            }
            Throwable error = ExceptionUtil.peelClientError((Throwable)t);
            if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                this.scheduleNextBroadcast(chainId, client, member, this.rescheduleOnErrorDelayMs);
                return;
            }
            this.chainIdRegistry.cleanUp((Object)member, chainId);
            log.error("Error when matching or deploying client filtering config to {} in cluster {}. Stopped sending config to this member.", new Object[]{member, cluster, error});
        }, (Executor)this.executor);
    }

    int nextChainId(Member member) {
        return this.chainIdRegistry.nextId((Object)member);
    }
}

