/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSummaryListCodec;
import com.hazelcast.client.impl.protocol.codec.MCAddWanBatchPublisherConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCApplyMCConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCChangeClusterStateCodec;
import com.hazelcast.client.impl.protocol.codec.MCChangeClusterVersionCodec;
import com.hazelcast.client.impl.protocol.codec.MCChangeWanReplicationStateCodec;
import com.hazelcast.client.impl.protocol.codec.MCCheckWanConsistencyCodec;
import com.hazelcast.client.impl.protocol.codec.MCClearWanQueuesCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetCPMembersCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetClusterMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetMapConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetMemberConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetSystemPropertiesCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetThreadDumpCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetTimedMemberStateCodec;
import com.hazelcast.client.impl.protocol.codec.MCInterruptHotRestartBackupCodec;
import com.hazelcast.client.impl.protocol.codec.MCMatchMCConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCPollMCEventsCodec;
import com.hazelcast.client.impl.protocol.codec.MCPromoteLiteMemberCodec;
import com.hazelcast.client.impl.protocol.codec.MCPromoteToCPMemberCodec;
import com.hazelcast.client.impl.protocol.codec.MCReadMetricsCodec;
import com.hazelcast.client.impl.protocol.codec.MCRemoveCPMemberCodec;
import com.hazelcast.client.impl.protocol.codec.MCResetCPSubsystemCodec;
import com.hazelcast.client.impl.protocol.codec.MCResetQueueAgeStatisticsCodec;
import com.hazelcast.client.impl.protocol.codec.MCRunConsoleCommandCodec;
import com.hazelcast.client.impl.protocol.codec.MCRunGcCodec;
import com.hazelcast.client.impl.protocol.codec.MCRunScriptCodec;
import com.hazelcast.client.impl.protocol.codec.MCShutdownClusterCodec;
import com.hazelcast.client.impl.protocol.codec.MCShutdownMemberCodec;
import com.hazelcast.client.impl.protocol.codec.MCTriggerForceStartCodec;
import com.hazelcast.client.impl.protocol.codec.MCTriggerHotRestartBackupCodec;
import com.hazelcast.client.impl.protocol.codec.MCTriggerPartialStartCodec;
import com.hazelcast.client.impl.protocol.codec.MCUpdateConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCUpdateMapConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCWanSyncMapCodec;
import com.hazelcast.client.impl.protocol.codec.SqlMappingDdlCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.management.dto.CPMemberDTO;
import com.hazelcast.internal.management.dto.ClientBwListDTO;
import com.hazelcast.internal.management.dto.MCEventDTO;
import com.hazelcast.internal.metrics.managementcenter.MetricsResultSet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.version.Version;
import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.wan.impl.WanSyncType;
import com.hazelcast.webmonitor.controller.dto.ClusterMetadata;
import com.hazelcast.webmonitor.controller.exception.JetNotSupportedApiException;
import com.hazelcast.webmonitor.service.client.MCMapConfig;
import com.hazelcast.webmonitor.service.client.MCWanBatchPublisherConfig;
import com.hazelcast.webmonitor.service.client.UpdateMapConfigParameters;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MCClient.class);
    private final HazelcastClientInstanceImpl hzClient;
    private final InternalSerializationService serializationService;

    public MCClient(HazelcastClientInstanceImpl hzClient) {
        this.hzClient = hzClient;
        this.serializationService = hzClient.getSerializationService();
    }

    public HazelcastInstance getHzClient() {
        return this.hzClient;
    }

    public String getClusterName() {
        return this.hzClient.getClientConfig().getClusterName();
    }

    public InternalSerializationService getSerializationService() {
        return this.hzClient.getSerializationService();
    }

    public void shutdown() {
        try {
            this.hzClient.shutdown();
        }
        catch (Exception e) {
            if (this.hzClient.getLifecycleService().isRunning()) {
                LOGGER.error("Hazelcast client for cluster {} failed to shut down.", (Object)this.getClusterName(), (Object)e);
            }
            LOGGER.debug("Exception while shutting down Hazelcast client for cluster {}.", (Object)this.getClusterName(), (Object)e);
        }
    }

    @Nonnull
    public CompletableFuture<MetricsResultSet> readMetricsAsync(Member member, long startSequence) {
        ClientMessage request = MCReadMetricsCodec.encodeRequest((UUID)member.getUuid(), (long)startSequence);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, request, null, member.getUuid());
        invocation.disallowRetryOnRandom();
        ClientMessageDecoder decoder = clientMessage -> {
            MCReadMetricsCodec.ResponseParameters response = MCReadMetricsCodec.decodeResponse((ClientMessage)clientMessage);
            return new MetricsResultSet(response.nextSequence, response.elements);
        };
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, decoder, false);
    }

    @Nonnull
    public CompletableFuture<Void> changeClusterState(ClusterState newState) {
        Preconditions.checkNotNull((Object)newState);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCChangeClusterStateCodec.encodeRequest((int)newState.getId()), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Void> resetQueueAgeMetrics(String queue) {
        Preconditions.checkNotNull((Object)queue);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCResetQueueAgeStatisticsCodec.encodeRequest((String)queue), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<MCMapConfig> getMapConfig(String map) {
        Preconditions.checkNotNull((Object)map);
        return this.doGetMapConfig(null, map);
    }

    @Nonnull
    public CompletableFuture<MCMapConfig> getMapConfig(Member member, String map) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)map);
        return this.doGetMapConfig(member, map);
    }

    private CompletableFuture<MCMapConfig> doGetMapConfig(Member member, String map) {
        ClientInvocation invocation;
        if (member == null) {
            invocation = new ClientInvocation(this.hzClient, MCGetMapConfigCodec.encodeRequest((String)map), (Object)map);
        } else {
            invocation = new ClientInvocation(this.hzClient, MCGetMapConfigCodec.encodeRequest((String)map), (Object)map, member.getUuid());
            invocation.disallowRetryOnRandom();
        }
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> {
            MCGetMapConfigCodec.ResponseParameters response = MCGetMapConfigCodec.decodeResponse((ClientMessage)clientMessage);
            MCMapConfig config = new MCMapConfig();
            config.setInMemoryFormat(InMemoryFormat.getById((int)response.inMemoryFormat));
            config.setBackupCount(response.backupCount);
            config.setAsyncBackupCount(response.asyncBackupCount);
            config.setTimeToLiveSeconds(response.timeToLiveSeconds);
            config.setMaxIdleSeconds(response.maxIdleSeconds);
            config.setMaxSize(response.maxSize);
            config.setMaxSizePolicy(MaxSizePolicy.getById((int)response.maxSizePolicy));
            config.setReadBackupData(response.readBackupData);
            config.setEvictionPolicy(EvictionPolicy.getById((int)response.evictionPolicy));
            config.setMergePolicy(response.mergePolicy);
            config.setGlobalIndexes(response.globalIndexes);
            return config;
        }, true);
    }

    @Nonnull
    public CompletableFuture<Void> updateMapConfig(Member member, UpdateMapConfigParameters parameters) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)parameters);
        Preconditions.checkNotNull((Object)parameters.getEvictionPolicy());
        Preconditions.checkNotNull((Object)parameters.getMaxSizePolicy());
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCUpdateMapConfigCodec.encodeRequest((String)parameters.getMap(), (int)parameters.getTimeToLiveSeconds(), (int)parameters.getMaxIdleSeconds(), (int)parameters.getEvictionPolicy().getId(), (boolean)parameters.isReadBackupData(), (int)parameters.getMaxSize(), (int)parameters.getMaxSizePolicy().getId()), (Object)parameters.getMap(), member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<String> getMemberConfig(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCGetMemberConfigCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCGetMemberConfigCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<Void> runGc(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCRunGcCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<String> getThreadDump(Member member, boolean dumpDeadLocks) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCGetThreadDumpCodec.encodeRequest((boolean)dumpDeadLocks), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCGetThreadDumpCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<String> getSqlDdlMapping(Member member, String mapName) {
        Preconditions.checkNotNull((Object)mapName);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, SqlMappingDdlCodec.encodeRequest((String)mapName), null, member.getUuid());
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, SqlMappingDdlCodec::decodeResponse);
    }

    public void shutdownMember(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCShutdownMemberCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        invocation.invoke();
    }

    @Nonnull
    public CompletableFuture<Void> promoteLiteMember(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCPromoteLiteMemberCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Map<String, String>> getSystemProperties(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCGetSystemPropertiesCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> {
            List systemProperties = MCGetSystemPropertiesCodec.decodeResponse((ClientMessage)clientMessage);
            Map result = MapUtil.createHashMap((int)systemProperties.size());
            for (Map.Entry property : systemProperties) {
                result.put((String)property.getKey(), (String)property.getValue());
            }
            return result;
        });
    }

    @Nonnull
    public CompletableFuture<Optional<String>> getTimedMemberState(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCGetTimedMemberStateCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> Optional.ofNullable(MCGetTimedMemberStateCodec.decodeResponse((ClientMessage)clientMessage)));
    }

    @Nonnull
    public CompletableFuture<Boolean> matchMCConfig(Member member, String eTag) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)eTag);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCMatchMCConfigCodec.encodeRequest((String)eTag), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCMatchMCConfigCodec::decodeResponse, false);
    }

    @Nonnull
    public CompletableFuture<Void> applyMCConfig(Member member, String eTag, ClientBwListDTO clientBwList) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)eTag);
        Preconditions.checkNotNull((Object)clientBwList);
        Preconditions.checkNotNull((Object)clientBwList.mode);
        Preconditions.checkNotNull((Object)clientBwList.entries);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCApplyMCConfigCodec.encodeRequest((String)eTag, (int)clientBwList.mode.getId(), (Collection)clientBwList.entries), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<ClusterMetadata> getClusterMetadata() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCGetClusterMetadataCodec.encodeRequest(), null);
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> {
            MCGetClusterMetadataCodec.ResponseParameters response = MCGetClusterMetadataCodec.decodeResponse((ClientMessage)clientMessage);
            return ClusterMetadata.builder().currentState(ClusterState.getById((int)response.currentState)).clusterTime(response.clusterTime).memberVersion(response.memberVersion).jetVersion(response.jetVersion).clusterId(response.isClusterIdExists ? response.clusterId : null).build();
        });
    }

    public ClientInvocationFuture shutdownCluster() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCShutdownClusterCodec.encodeRequest(), null);
        return invocation.invoke();
    }

    @Nonnull
    public CompletableFuture<Void> changeClusterVersion(Version version) {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCChangeClusterVersionCodec.encodeRequest((byte)version.getMajor(), (byte)version.getMinor()), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<String> runScript(Member member, String engine, String script) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)script);
        Preconditions.checkNotNull((Object)engine);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCRunScriptCodec.encodeRequest((String)engine, (String)script), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCRunScriptCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<String> runConsoleCommand(Member member, String namespace, String command) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)command);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCRunConsoleCommandCodec.encodeRequest((String)namespace, (String)command), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCRunConsoleCommandCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<Void> changeWanReplicationState(Member member, String wanReplicationName, String wanPublisherId, WanPublisherState newState) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)wanReplicationName);
        Preconditions.checkNotNull((Object)wanPublisherId);
        Preconditions.checkNotNull((Object)newState);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCChangeWanReplicationStateCodec.encodeRequest((String)wanReplicationName, (String)wanPublisherId, (byte)newState.getId()), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Void> clearWanQueues(Member member, String wanReplicationName, String wanPublisherId) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)wanReplicationName);
        Preconditions.checkNotNull((Object)wanPublisherId);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCClearWanQueuesCodec.encodeRequest((String)wanReplicationName, (String)wanPublisherId), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<AddWanConfigResult> addWanReplicationConfig(MCWanBatchPublisherConfig config) {
        Preconditions.checkNotNull((Object)config);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCAddWanBatchPublisherConfigCodec.encodeRequest((String)config.getName(), (String)config.getTargetCluster(), (String)config.getPublisherId(), (String)config.getEndpoints(), (int)config.getQueueCapacity(), (int)config.getBatchSize(), (int)config.getBatchMaxDelayMillis(), (int)config.getResponseTimeoutMillis(), (int)config.getAckType().getId(), (int)config.getQueueFullBehaviour().getId()), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> {
            MCAddWanBatchPublisherConfigCodec.ResponseParameters response = MCAddWanBatchPublisherConfigCodec.decodeResponse((ClientMessage)clientMessage);
            return new AddWanConfigResult((Collection)response.addedPublisherIds, (Collection)response.ignoredPublisherIds);
        });
    }

    @Nonnull
    public CompletableFuture<UUID> wanSyncMap(String wanReplicationName, String wanPublisherId, String mapName) {
        Preconditions.checkNotNull((Object)wanReplicationName);
        Preconditions.checkNotNull((Object)wanPublisherId);
        Preconditions.checkNotNull((Object)mapName);
        return this.wanSyncMap(wanReplicationName, wanPublisherId, WanSyncType.SINGLE_MAP, mapName);
    }

    @Nonnull
    public CompletableFuture<UUID> wanSyncAllMaps(String wanReplicationName, String wanPublisherId) {
        Preconditions.checkNotNull((Object)wanReplicationName);
        Preconditions.checkNotNull((Object)wanPublisherId);
        return this.wanSyncMap(wanReplicationName, wanPublisherId, WanSyncType.ALL_MAPS, null);
    }

    private CompletableFuture<UUID> wanSyncMap(String wanReplicationName, String wanPublisherId, WanSyncType syncType, String map) {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCWanSyncMapCodec.encodeRequest((String)wanReplicationName, (String)wanPublisherId, (int)syncType.getType(), (String)map), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCWanSyncMapCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<UUID> startConfigurationUpdate(String configPatch) {
        Preconditions.checkNotNull((Object)configPatch);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCUpdateConfigCodec.encodeRequest((String)configPatch), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCUpdateConfigCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<UUID> checkWanConsistency(String wanReplicationName, String wanPublisherId, String mapName) {
        Preconditions.checkNotNull((Object)wanReplicationName);
        Preconditions.checkNotNull((Object)wanPublisherId);
        Preconditions.checkNotNull((Object)mapName);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCCheckWanConsistencyCodec.encodeRequest((String)wanReplicationName, (String)wanPublisherId, (String)mapName), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCCheckWanConsistencyCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<List<MCEventDTO>> pollMCEvents(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCPollMCEventsCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCPollMCEventsCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<List<CPMemberDTO>> getCPMembers() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCGetCPMembersCodec.encodeRequest(), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> MCGetCPMembersCodec.decodeResponse((ClientMessage)clientMessage).stream().map(e -> new CPMemberDTO((UUID)e.getKey(), (UUID)e.getValue())).collect(Collectors.toList()));
    }

    @Nonnull
    public CompletableFuture<Void> promoteToCPMember(Member member) {
        Preconditions.checkNotNull((Object)member);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCPromoteToCPMemberCodec.encodeRequest(), null, member.getUuid());
        invocation.disallowRetryOnRandom();
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Void> removeCPMember(UUID cpMemberUuid) {
        Preconditions.checkNotNull((Object)cpMemberUuid);
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCRemoveCPMemberCodec.encodeRequest((UUID)cpMemberUuid), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Void> resetCPSubsystem() {
        Member masterAddress = this.hzClient.getClientClusterService().getMasterMember();
        if (masterAddress == null) {
            throw new IllegalStateException("Master member is not known yet.");
        }
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCResetCPSubsystemCodec.encodeRequest(), null, masterAddress.getUuid());
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Boolean> triggerPartialStart() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCTriggerPartialStartCodec.encodeRequest(), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCTriggerPartialStartCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<Boolean> triggerForceStart() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCTriggerForceStartCodec.encodeRequest(), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, MCTriggerForceStartCodec::decodeResponse);
    }

    @Nonnull
    public CompletableFuture<Void> triggerHotRestartBackup() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCTriggerHotRestartBackupCodec.encodeRequest(), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Void> interruptHotRestartBackup() {
        ClientInvocation invocation = new ClientInvocation(this.hzClient, MCInterruptHotRestartBackupCodec.encodeRequest(), null);
        return new ClientDelegatingFuture(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public List<JobSummary> getJobSummaryList() {
        ClientInvocation inv = new ClientInvocation(this.hzClient, JetGetJobSummaryListCodec.encodeRequest(), null, this.hzClient.getClientClusterService().getMasterMember().getUuid());
        try {
            ClientMessage response = (ClientMessage)inv.invoke().get();
            return (List)this.serializationService.toObject((Object)JetGetJobSummaryListCodec.decodeResponse((ClientMessage)response));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public Collection<JobStateSnapshot> getJobStateSnapshots() {
        return (Collection)this.executeJetOperation(() -> ((JetService)this.hzClient.getJet()).getJobStateSnapshots());
    }

    @Nullable
    public JobStateSnapshot getJobStateSnapshot(@Nonnull String name) {
        return (JobStateSnapshot)this.executeJetOperation(() -> this.hzClient.getJet().getJobStateSnapshot(name));
    }

    @Nonnull
    public List<Job> getJobs() {
        return (List)this.executeJetOperation(() -> ((JetService)this.hzClient.getJet()).getJobs());
    }

    protected <T> T executeJetOperation(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (UnsupportedOperationException e) {
            throw new JetNotSupportedApiException((Throwable)e);
        }
    }
}

