/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.diagnostics.Diagnostics;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.CentralManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberStateReceivedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.TimedMemberStateConsumer;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class TimedMemberStateConsumer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimedMemberStateConsumer.class);
    final TMSJsonReader tmsJsonReader = new TMSJsonReader();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, r -> new Thread(r, "TimedMemberStateConsumer"));
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final CentralManager centralManager;
    private final MCClientManager mcClientManager;
    private final Notifier notifier;
    private final MetricsConfigurationProperties properties;
    private final ApplicationEventPublisher eventPublisher;

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        MCClient client = this.mcClientManager.clientFor(event.getCluster());
        event.getMembers().forEach(member -> this.readState(this.chainIdRegistry.nextId(member), client, member));
    }

    private void readState(int chainId, MCClient client, Member member) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - retrieving timed members state", (Object)member);
        client.getTimedMemberState(member).whenCompleteAsync((optionalJson, t) -> {
            String cluster = client.getClusterName();
            if (t == null) {
                this.scheduleReadState(chainId, client, member, this.properties.getStateRescheduleDelay());
                Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - retrieved timed members state", (Object)member);
                TimedMemberState memberState = this.deserializeJson(optionalJson, cluster, member);
                if (memberState == null) {
                    return;
                }
                MemberIdentifier memberIdent = MemberIdentifier.of((String)client.getClusterName(), (Member)member);
                this.eventPublisher.publishEvent((ApplicationEvent)new MemberStateReceivedEvent(memberIdent, memberState));
                Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - adding timed members state to all state", (Object)member);
                this.centralManager.addMemberState(memberState, cluster);
                Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - added timed members state to all state", (Object)member);
            } else {
                Throwable error = ExceptionUtil.peelClientError((Throwable)t);
                log.debug("Exception when requesting state from {} of cluster {}.", new Object[]{member, cluster, error});
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleReadState(chainId, client, member, this.properties.getStateRescheduleOnErrorDelay());
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)member, chainId);
                log.error("Error reading state for {} from cluster {}. Stopped state collection for this member.", new Object[]{member, cluster, t});
            }
        }, (Executor)this.executorService);
    }

    private TimedMemberState deserializeJson(Optional<String> json, String cluster, Member member) {
        if (!json.isPresent()) {
            log.warn("No state found on member {} from cluster {}.", (Object)member, (Object)cluster);
            return null;
        }
        try {
            return this.tmsJsonReader.read(json.get());
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to parse statistics received from member %s of cluster %s: %s.", member, cluster, e.getMessage());
            log.warn(errorMessage, (Throwable)e);
            this.notifier.signal(Note.Matter.RECEIVED_MALFORMED_METRICS.on(cluster, errorMessage + " Check the logs for details."));
            return null;
        }
    }

    private void scheduleReadState(int chainId, MCClient client, Member member, Duration delay) {
        this.executorService.schedule(() -> {
            try {
                this.readState(chainId, client, member);
            }
            catch (Exception e) {
                log.error("Error reading state from {} of cluster {}.", new Object[]{member, client.getClusterName(), e});
            }
        }, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    int nextChainId(Member member) {
        return this.chainIdRegistry.nextId((Object)member);
    }

    @ConstructorProperties(value={"centralManager", "mcClientManager", "notifier", "properties", "eventPublisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TimedMemberStateConsumer(CentralManager centralManager, MCClientManager mcClientManager, Notifier notifier, MetricsConfigurationProperties properties, ApplicationEventPublisher eventPublisher) {
        this.centralManager = centralManager;
        this.mcClientManager = mcClientManager;
        this.notifier = notifier;
        this.properties = properties;
        this.eventPublisher = eventPublisher;
    }
}

