/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.TablePresetDTO;
import com.hazelcast.webmonitor.model.sql.TablePresetModel;
import com.hazelcast.webmonitor.repositories.sql.TablePresetDAO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class TablePresetService {
    private final TablePresetDAO dao;

    public List<TablePresetDTO> getPresetsOfTable(String tableId) {
        return this.dao.findPresetsByTableId(tableId).stream().map(TablePresetDTO::fromModel).collect(Collectors.toList());
    }

    public void setPresetsOfTable(String tableId, List<TablePresetDTO> presets) {
        this.dao.insertOrUpdate(tableId, presets.stream().map(dto -> new TablePresetModel(dto.getId(), tableId, dto.getName(), dto.getReadonly(), dto.getCurrent(), dto.getHiddenColumns())).collect(Collectors.toList()));
    }

    @ConstructorProperties(value={"dao"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TablePresetService(TablePresetDAO dao) {
        this.dao = dao;
    }
}

