/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hazelcast.webmonitor.controller.dto.SlowOperationDTO;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.hz.req.state.ClusterState;
import com.hazelcast.webmonitor.model.hz.req.state.LocalOperationStats;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StateManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateManager.class);
    static final int INTERVAL_MSEC = 10000;
    private static final int LATEST_STATE_TTL_SEC = 120;
    private static final SortedSet<String> EMPTY_INSTANCE_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private final Cache<String, AllState> latestStateCache = CacheBuilder.newBuilder().expireAfterWrite(120L, TimeUnit.SECONDS).build();

    @Autowired
    public StateManager() {
    }

    public Set<String> getClusterNames() {
        return this.latestStateCache.asMap().keySet();
    }

    public void cacheLatestState(String cluster, AllState state) {
        this.latestStateCache.put((Object)cluster, (Object)state);
    }

    @Nullable
    public AllState getLatestState(String cluster) {
        return (AllState)this.latestStateCache.getIfPresent((Object)cluster);
    }

    @Nullable
    public ClusterState getClusterState(String cluster) {
        AllState latestState = this.getLatestState(cluster);
        if (latestState == null) {
            return null;
        }
        if (latestState.getMasterState().isPresent()) {
            TimedMemberState masterState = (TimedMemberState)latestState.getMasterState().get();
            return masterState.getMemberState().getNodeState().getClusterState();
        }
        Iterator iterator = latestState.getMemberStates().iterator();
        if (iterator.hasNext()) {
            MemberState randomMemberState = (MemberState)iterator.next();
            return randomMemberState.getNodeState().getClusterState();
        }
        return null;
    }

    public AllState getLatestStateIfSameInterval(String cluster, long now) {
        AllState state = (AllState)this.latestStateCache.getIfPresent((Object)cluster);
        if (state != null && Math.abs(now - state.getTime()) < 10000L) {
            return state;
        }
        return null;
    }

    public static long floorTimeToInterval(long now) {
        return now - now % 10000L;
    }

    public String getMemberAddress(String cluster, String memberUuid) {
        AllState state = this.getLatestState(cluster);
        if (state != null) {
            for (MemberState memberState : state.getMemberStates()) {
                if (!memberState.getUuid().equals(memberUuid)) continue;
                return memberState.getAddress();
            }
        }
        return null;
    }

    public SortedSet<String> getInstanceNames(InstanceType type, String cluster) {
        AllState state = this.getLatestState(cluster);
        return state == null ? EMPTY_INSTANCE_SET : state.getInstanceNames(type);
    }

    public List<SlowOperationDTO> getSlowOperationsList(String cluster, String member) {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList<SlowOperationDTO> result = new ArrayList<SlowOperationDTO>();
        MemberState memberState = (MemberState)state.getMemberStates().get(member);
        if (memberState != null) {
            LocalOperationStats localOperations = memberState.getOperationStats();
            List dtos = localOperations.getSlowOperations().stream().map(dto -> SlowOperationDTO.builder().operation(dto.getOperation()).stackTrace(dto.getStackTrace()).totalInvocations(dto.getTotalInvocations()).build()).collect(Collectors.toList());
            result.addAll(dtos);
        }
        return result;
    }

    public Map<String, ClientEndPointDTO> getClients(String cluster) {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyMap();
        }
        return state.getClientsPerUuid();
    }

    public Map<String, ClientAttributes> getClientAttributes(String cluster) {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyMap();
        }
        return state.getClientAttributes();
    }

    public void verifyDataAccessEnabled(String cluster) {
        AllState state = this.getLatestState(cluster);
        if (state != null && !state.isDataAccessEnabled()) {
            throw new OperationFailedApiException("Management Center Data Access is disabled in member config.");
        }
    }
}

