/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NodeLimitStatus
implements Notifier.Status {
    private final LoadingCache<String, Boolean> clusterNodeLimitExcessStatuses = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build(CacheLoader.from(key -> false));
    private static final int CLUSTER_NODE_LIMIT_EXCESS_TTL_MINS = 10;

    @Autowired
    public NodeLimitStatus(Notifier notifier) {
        notifier.register((Notifier.Status)this);
    }

    public Note check(@Nonnull String cluster) {
        Objects.requireNonNull(cluster);
        if (((Boolean)this.clusterNodeLimitExcessStatuses.getUnchecked((Object)cluster)).booleanValue()) {
            String msg = "Cluster [" + cluster + "] has more than " + 3 + " members. Receiving stats for it has been blocked. You need to configure a valid license on Management Center to continue receiving stats for it.";
            return Note.Matter.NODE_LIMIT_EXCEEDED.on(cluster, msg);
        }
        return null;
    }

    void exceedsNodeLimit(String cluster) {
        this.clusterNodeLimitExcessStatuses.put((Object)cluster, (Object)true);
    }

    void underNodeLimit(String cluster) {
        this.clusterNodeLimitExcessStatuses.put((Object)cluster, (Object)false);
    }
}

