/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.imdg.MemberMetricsQueryFactory;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import org.springframework.stereotype.Service;

@Service
public class MemberStatsService {
    private static final long LOOKUP_INTERVAL_MS = 60000L;
    private final MetricsService metricsService;
    private final Clock clock;

    public MemberStatsService(MetricsService metricsService, Clock clock) {
        this.metricsService = metricsService;
        this.clock = clock;
    }

    public long getAvailableProcessors(String cluster, String member, long time) {
        long end = time > 0L ? time : this.clock.currentTimeMillis();
        long start = end - 60000L;
        MemberMetricsQueryFactory memberMetricsQueryFactory = new MemberMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
        return this.metricsService.queryLatestRaw(memberMetricsQueryFactory.availableProcessorsQuery()).map(DataPointAware::getValue).orElse(0L);
    }
}

