/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.management.dto.MCEventDTO;
import com.hazelcast.internal.management.events.EventMetadata;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.version.Version;
import com.hazelcast.webmonitor.diagnostics.Diagnostics;
import com.hazelcast.webmonitor.events.IncomingEventDispatcher;
import com.hazelcast.webmonitor.events.model.AbstractEvent;
import com.hazelcast.webmonitor.events.model.EventFactory;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EventsConsumer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventsConsumer.class);
    private static final long DEFAULT_RESCHEDULE_DELAY_MS = 1000L;
    private static final long DEFAULT_RESCHEDULE_ON_ERROR_DELAY_MS = 5000L;
    private static final List<EventMetadata.EventType> TYPES_WITHOUT_UUID = ImmutableList.of((Object)EventMetadata.EventType.WAN_CONSISTENCY_CHECK_IGNORED, (Object)EventMetadata.EventType.WAN_CONFIGURATION_ADDED, (Object)EventMetadata.EventType.WAN_CONFIGURATION_EXTENDED, (Object)EventMetadata.EventType.ADD_WAN_CONFIGURATION_IGNORED);
    public static final Version VERSION_5_0 = Version.of((int)5, (int)0);
    private final IncomingEventDispatcher eventDispatcher;
    private final long rescheduleDelayMs;
    private final long rescheduleOnErrorDelayMs;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, r -> new Thread(r, "EventsConsumer"));
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final MCClientManager mcClientManager;

    @Autowired
    public EventsConsumer(IncomingEventDispatcher eventDispatcher, MCClientManager mcClientManager) {
        this(eventDispatcher, 1000L, 5000L, mcClientManager);
    }

    EventsConsumer(IncomingEventDispatcher eventDispatcher, long rescheduleDelayMs, long rescheduleOnErrorDelayMs, MCClientManager mcClientManager) {
        this.eventDispatcher = eventDispatcher;
        this.rescheduleDelayMs = rescheduleDelayMs;
        this.rescheduleOnErrorDelayMs = rescheduleOnErrorDelayMs;
        this.mcClientManager = mcClientManager;
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        MCClient client = this.mcClientManager.clientFor(event.getCluster());
        event.getMembers().forEach(member -> this.pollEvents(this.nextChainId(member), client, member));
    }

    private void pollEvents(int chainId, MCClient client, Member member) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - polling MC events", (Object)member);
        client.pollMCEvents(member).whenCompleteAsync((events, t) -> {
            String cluster = client.getClusterName();
            if (t == null) {
                this.scheduleNextPoll(chainId, client, member, this.rescheduleDelayMs);
                Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - polled {} MC events", (Object)member, (Object)events.size());
                if (events.isEmpty()) {
                    return;
                }
                log.info("Received {} events from {} of cluster {}.", new Object[]{events.size(), member, cluster});
                try {
                    Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - storing MC events", (Object)member);
                    MemberIdentifier memberIdent = MemberIdentifier.of((String)client.getClusterName(), (Member)member);
                    boolean shouldSetUuid = !member.getVersion().asVersion().isGreaterOrEqual(VERSION_5_0);
                    List localEvents = events.stream().map(dto -> EventsConsumer.mapMCEventDTO((MemberIdentifier)memberIdent, (MCEventDTO)dto, (boolean)shouldSetUuid)).collect(Collectors.toList());
                    this.eventDispatcher.dispatch(cluster, localEvents);
                }
                catch (Exception e) {
                    log.warn("Could not process events from {} of cluster {}.", new Object[]{member, cluster, e});
                }
                finally {
                    Diagnostics.DIAGNOSTICS_LOGGER.trace("{} - stored MC events", (Object)member);
                }
            } else {
                Throwable error = ExceptionUtil.peelClientError((Throwable)t);
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleNextPoll(chainId, client, member, this.rescheduleOnErrorDelayMs);
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)member, chainId);
                log.error("Error when requesting events from {} of cluster {}. Stopped polling events from this member.", new Object[]{member, cluster, error});
            }
        }, (Executor)this.executorService);
    }

    private void scheduleNextPoll(int chainId, MCClient client, Member member, long delayMs) {
        this.executorService.schedule(() -> {
            try {
                this.pollEvents(chainId, client, member);
            }
            catch (Exception e) {
                log.error("Error reading events from {} of cluster {}.", new Object[]{member, client.getClusterName(), e});
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    private static AbstractEvent mapMCEventDTO(MemberIdentifier memberIdent, MCEventDTO dto, boolean shouldSetUuid) {
        Map data = EventsConsumer.readEventData((String)dto.getDataJson());
        EventMetadata.EventType eventType = EventMetadata.EventType.withCode((int)dto.getType());
        if (shouldSetUuid && (data.get("uuid") == null || "null".equals(data.get("uuid")))) {
            if (TYPES_WITHOUT_UUID.contains(eventType)) {
                data.put("uuid", UuidUtil.newUnsecureUuidString());
            } else {
                log.warn("Unexpected event {} from member {} without UUID with data: {}", new Object[]{eventType, memberIdent, data});
            }
        }
        return EventFactory.createEvent((MemberIdentifier)memberIdent, (long)dto.getTimestamp(), (EventMetadata.EventType)eventType, (Map)data);
    }

    int nextChainId(Member member) {
        return this.chainIdRegistry.nextId((Object)member);
    }

    static Map<String, Object> readEventData(String rawJson) {
        try {
            return (Map)SerializationUtil.OBJECT_MAPPER.readValue(rawJson, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Can't parse event data JSON", e);
        }
    }
}

