/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.version.Version;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.controller.dto.MemberDetailsDTO;
import com.hazelcast.webmonitor.controller.dto.UpdateClusterRequestDTO;
import com.hazelcast.webmonitor.controller.exception.ClientFailedToStartApiException;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.service.BrowserHeartBeatEvent;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.Utils;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.exception.InvalidClusterConnectionConfigException;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClusterManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterManager.class);
    private static final Version HAZELCAST_5_0 = Version.of((String)"5.0.0");
    private final ClusterRepository repository;
    private final JdbiHistories histories;
    private final OperationDispatcher operationDispatcher;
    private final MCClientManager clientManager;
    private final StateManager stateManager;
    private final MemberManager memberManager;
    private final Notifier notifier;
    private final ApplicationEventPublisher publisher;
    @Value(value="${spring.application.name:application}")
    private String springApplicationName = "application";

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.springApplicationName.equals(event.getApplicationContext().getId())) {
            return;
        }
        List enabledClusters = this.repository.getEnabledClusters();
        log.info("Connecting to {} enabled cluster(s) on startup.", (Object)enabledClusters.size());
        enabledClusters.forEach(cluster -> {
            try {
                ClientConfig config = cluster.createClientConfig();
                this.clientManager.connect(config);
            }
            catch (ClientFailedToStartApiException config) {
            }
            catch (Exception e) {
                log.warn("Failed to start client for cluster {}.", (Object)cluster.getName(), (Object)e);
            }
        });
    }

    public void add(ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        ClusterModel cluster = this.repository.add(configType, configFileContent, enabled);
        this.connect(cluster);
    }

    public void add(AddClusterRequestDTO dto) {
        ClusterModel cluster = this.repository.add(dto);
        this.connect(cluster);
    }

    private void connect(ClusterModel cluster) {
        ClientConfig clientConfig = cluster.createClientConfig();
        if (cluster.isEnabled()) {
            this.clientManager.connect(clientConfig);
        }
    }

    public void update(String clusterName, ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        ClusterModel cluster = this.repository.update(clusterName, configType, configFileContent, enabled);
        this.reconnect(clusterName, cluster);
    }

    public boolean createOrUpdateCluster(ClusterModel cluster) throws InvalidClusterConnectionConfigException {
        if (!cluster.hasConsistentClusterName()) {
            throw new InvalidClusterConnectionConfigException(cluster.getName(), cluster.createClientConfig().getClusterName());
        }
        this.clientManager.disconnect(cluster.getName());
        boolean update = this.repository.insertOrUpdate(cluster);
        this.connect(cluster);
        return update;
    }

    public void update(String clusterName, UpdateClusterRequestDTO dto) {
        ClusterModel cluster = this.repository.update(clusterName, dto);
        this.reconnect(clusterName, cluster);
    }

    private void reconnect(String clusterName, ClusterModel cluster) {
        this.clientManager.disconnect(clusterName);
        this.connect(cluster);
    }

    public void remove(String cluster) {
        this.histories.removeByCluster(cluster);
        this.repository.remove(cluster);
        this.clientManager.disconnect(cluster);
    }

    public ClusterModel getCluster(String cluster) {
        ClusterModel rawModel = this.repository.getCluster(cluster);
        String clientConfig = rawModel.getClientConfig();
        ClusterModel.ClientConfigType clientConfigType = rawModel.getClientConfigType();
        if (clientConfigType == null || StringUtil.isNullOrEmptyAfterTrim((String)clientConfig)) {
            return rawModel;
        }
        if (clientConfigType == ClusterModel.ClientConfigType.XML) {
            clientConfig = this.sanitizeXmlConfig(clientConfig);
        } else if (clientConfigType == ClusterModel.ClientConfigType.YAML) {
            clientConfig = this.sanitizeYamlConfig(clientConfig);
        }
        return rawModel.toBuilder().clientConfig(clientConfig).build();
    }

    private String sanitizeXmlConfig(String clientConfig) {
        ClientConfig parsedConfig = new XmlClientConfigBuilder((InputStream)new ByteArrayInputStream(clientConfig.getBytes(StandardCharsets.UTF_8))).build();
        ClientSecurityConfig securityConfig = parsedConfig.getSecurityConfig();
        UsernamePasswordIdentityConfig userPassConfig = securityConfig.getUsernamePasswordIdentityConfig();
        TokenIdentityConfig tokenIdentityConfig = securityConfig.getTokenIdentityConfig();
        if (userPassConfig == null && tokenIdentityConfig == null) {
            return clientConfig;
        }
        if (userPassConfig != null) {
            clientConfig = clientConfig.replace(userPassConfig.getPassword(), "****");
        }
        if (tokenIdentityConfig != null) {
            if (tokenIdentityConfig.getEncoding() == TokenEncoding.BASE64) {
                clientConfig = clientConfig.replace(tokenIdentityConfig.getTokenEncoded(), "****");
            } else if (tokenIdentityConfig.getEncoding() == TokenEncoding.NONE) {
                clientConfig = clientConfig.replace(new String(tokenIdentityConfig.getToken(), StandardCharsets.UTF_8), "****");
            }
        }
        return clientConfig;
    }

    private String sanitizeYamlConfig(String clientConfig) {
        YamlMapping yamlRoot = (YamlMapping)YamlLoader.load((String)clientConfig);
        String password = this.getPassword(yamlRoot);
        String token = this.getToken(yamlRoot);
        if (password != null) {
            clientConfig = clientConfig.replace(password, "****");
        }
        if (token != null) {
            clientConfig = clientConfig.replace(token, "****");
        }
        return clientConfig;
    }

    private String getPassword(YamlMapping yamlRoot) {
        try {
            return (String)yamlRoot.childAsMapping("hazelcast-client").childAsMapping("security").childAsMapping("username-password").childAsScalar("password").nodeValue();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private String getToken(YamlMapping yamlRoot) {
        try {
            return (String)yamlRoot.childAsMapping("hazelcast-client").childAsMapping("security").childAsMapping("token").childAsScalar("value").nodeValue();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public List<String> getAllClusterNames() {
        return this.repository.getAllClusterNames();
    }

    public List<ClusterModel> getAllClusterConfigs() {
        return this.repository.getAllClusters();
    }

    public List<String> getConnectedClusterNames() {
        return this.clientManager.getConnectedClusters().stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public void changeState(String cluster, ClusterState newState) {
        this.operationDispatcher.executeOnCluster(cluster, mcClient -> mcClient.changeClusterState(newState), e -> String.format("Failed to change state of cluster %s.", cluster));
    }

    public Version rollingUpgradeNextVersion(String cluster) {
        String versionString = this.clusterVersion(cluster);
        if (versionString == null) {
            return null;
        }
        if (versionString.equals("4.2")) {
            return HAZELCAST_5_0;
        }
        Version current = Version.of((String)versionString);
        return Version.of((int)current.getMajor(), (int)(current.getMinor() + 1));
    }

    public void changeVersion(String cluster, Version newVersion) {
        this.operationDispatcher.executeOnCluster(cluster, mcClient -> mcClient.changeClusterVersion(newVersion), e -> String.format("Failed to change version of cluster %s.", cluster));
    }

    public void shutdown(String cluster) {
        this.operationDispatcher.executeOnClusterAsync(cluster, MCClient::shutdownCluster, e -> String.format("Failed to shutdown cluster %s.", cluster));
    }

    public void runVersionMismatchDetection(String cluster) {
        HashMap<String, String> versionMismatchMembers = new HashMap<String, String>();
        AllState state = this.stateManager.getLatestState(cluster);
        String clusterVersion = ClusterManager.clusterVersion((AllState)state);
        if (clusterVersion != null) {
            for (Map.Entry stateEntry : state.getMemberStates().entries()) {
                MemberState memberState = (MemberState)stateEntry.getValue();
                String string = memberState.getAddress();
                String version = memberState.getNodeState().getMemberVersion().toShortFormat();
                if (version.equals(clusterVersion)) continue;
                versionMismatchMembers.put(string, version);
            }
            if (!versionMismatchMembers.isEmpty()) {
                String version = "";
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : versionMismatchMembers.entrySet()) {
                    String address = (String)entry.getKey();
                    version = (String)entry.getValue();
                    sb.append(address).append(",");
                }
                String message = "The current cluster version is " + clusterVersion + " whereas node(s) [" + sb + "]'s version is " + version + "";
                this.notifier.signal(Note.Matter.RECEIVED_ROLLING_UPGRADE_INDICATION.on(cluster, message));
            }
        }
    }

    public String clusterVersion(String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        return ClusterManager.clusterVersion((AllState)state);
    }

    private static String clusterVersion(AllState state) {
        if (state == null) {
            return null;
        }
        String master = Utils.getMaster((AllState)state);
        if (master == null) {
            return null;
        }
        MemberState memberState = (MemberState)state.getMemberStates().get(master);
        return memberState.getNodeState().getClusterVersion().toShortFormat();
    }

    public boolean isJetEnabled(String cluster) {
        List members = this.memberManager.getMembers(cluster, 0L, 0L);
        if (members.isEmpty()) {
            return false;
        }
        return members.stream().allMatch(MemberDetailsDTO::isJetEnabled);
    }

    public void verifyClusterConnected(String cluster) {
        if (!this.isClusterConnected(cluster)) {
            throw new NoClusterApiException(cluster);
        }
    }

    public boolean isClusterConnected(String cluster) {
        return this.getConnectedClusterNames().contains(cluster);
    }

    public Stream<Note> anyNotifications(String cluster) {
        this.publisher.publishEvent((Object)new BrowserHeartBeatEvent(cluster));
        return Arrays.stream(this.notifier.notes(cluster));
    }

    @ConstructorProperties(value={"repository", "histories", "operationDispatcher", "clientManager", "stateManager", "memberManager", "notifier", "publisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterManager(ClusterRepository repository, JdbiHistories histories, OperationDispatcher operationDispatcher, MCClientManager clientManager, StateManager stateManager, MemberManager memberManager, Notifier notifier, ApplicationEventPublisher publisher) {
        this.repository = repository;
        this.histories = histories;
        this.operationDispatcher = operationDispatcher;
        this.clientManager = clientManager;
        this.stateManager = stateManager;
        this.memberManager = memberManager;
        this.notifier = notifier;
        this.publisher = publisher;
    }
}

