/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.oidc;

import com.hazelcast.webmonitor.security.UserHasNoRolesException;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToAuthoritiesMapper;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticationException;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.UserInfoRetrieval;
import com.hazelcast.webmonitor.utils.StringUtil;
import com.nimbusds.oauth2.sdk.ParseException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

class AuthenticationCompletion {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationCompletion.class);
    private final HttpSession session;
    private final URI requestURI;
    private final OidcConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String completeAuthentication() throws ParseException {
        try {
            JSONObject userInfo = new UserInfoRetrieval(this.session, this.requestURI, this.config).fetch();
            UsernamePasswordAuthenticationToken authentication = this.mapUserInfoJsonToAuthentication(userInfo);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            String string = (String)authentication.getPrincipal();
            return string;
        }
        finally {
            this.session.removeAttribute("oidc_state");
            this.session.removeAttribute("oidc_nonce");
        }
    }

    private UsernamePasswordAuthenticationToken mapUserInfoJsonToAuthentication(JSONObject userInfo) {
        List groups;
        String userIdClaimName = this.config.getUserIdClaimName();
        String userId = userInfo.getAsString(userIdClaimName);
        if (StringUtil.isNullOrEmptyAfterTrim((String)userId)) {
            throw new OidcAuthenticationException("No '" + userIdClaimName + "' claim returned from the OpenID provider.");
        }
        String groupsClaimName = this.config.getGroupsClaimName();
        Object groupsJson = userInfo.get((Object)groupsClaimName);
        List list = groupsJson instanceof JSONArray ? Arrays.stream(((JSONArray)groupsJson).toArray()).filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList()) : (groups = Collections.emptyList());
        if (groups.isEmpty()) {
            throw new OidcAuthenticationException("No '" + groupsClaimName + "' claim returned from the OpenID provider.");
        }
        LOGGER.debug("Groups for user: {}", groups);
        Set roles = GroupsToAuthoritiesMapper.mapGroupsToAuthorities(groups, (GroupsToRolesMappingConfig)this.config.getGroupsToRolesMappingConfig());
        if (roles.isEmpty()) {
            throw new UserHasNoRolesException();
        }
        return new UsernamePasswordAuthenticationToken((Object)userId, null, (Collection)roles);
    }

    @ConstructorProperties(value={"session", "requestURI", "config"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthenticationCompletion(HttpSession session, URI requestURI, OidcConfig config) {
        this.session = session;
        this.requestURI = requestURI;
        this.config = config;
    }
}

