/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.jaas;

import com.google.common.collect.ImmutableList;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.jaas.JaasAuthorityGranter;
import com.hazelcast.webmonitor.security.spi.impl.jaas.JaasConfig;
import com.hazelcast.webmonitor.security.spi.impl.jaas.PersistentJaasConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import lombok.Generated;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.jaas.AuthorityGranter;
import org.springframework.security.authentication.jaas.DefaultJaasAuthenticationProvider;
import org.springframework.security.authentication.jaas.memory.InMemoryConfiguration;

public class JaasSecurityProvider
implements SecurityProvider {
    public static final String JAAS_SECURITY_PROVIDER_NAME = "JAAS";
    private static final List<SecurityConfigParameter> CONFIG_PARAMETERS = ImmutableList.builder().add((Object)SecurityConfigParameter.stringParam((String)"loginModuleClass", (String)"Login Module Class", (String)"com.yourcompany.MyLoginModule")).addAll((Iterable)GroupsToRolesMappingConfig.CONFIG_PARAMETERS).build();
    private final PersistentJaasConfig persistentJaasConfig;

    public String getName() {
        return JAAS_SECURITY_PROVIDER_NAME;
    }

    public List<SecurityConfigParameter> getConfigParameters() {
        return CONFIG_PARAMETERS;
    }

    public void saveConfig(Map<String, String> parameters) {
        JaasConfig jaasConfig = JaasConfig.fromMap(parameters);
        String loginModuleClass = jaasConfig.getLoginModuleClass();
        try {
            Thread.currentThread().getContextClassLoader().loadClass(loginModuleClass);
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("Failed to load LoginModule class named [" + loginModuleClass + "]. Please check your classpath contains your JAAS provider JAR.", (Throwable)e);
        }
        this.persistentJaasConfig.write((SecurityProviderConfig)jaasConfig);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        JaasConfig jaasConfig = this.persistentJaasConfig.get();
        DefaultJaasAuthenticationProvider authProvider = new DefaultJaasAuthenticationProvider();
        InMemoryConfiguration config = new InMemoryConfiguration(Collections.singletonMap("SPRINGSECURITY", new AppConfigurationEntry[]{new AppConfigurationEntry(jaasConfig.getLoginModuleClass(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap())}));
        authProvider.setConfiguration((Configuration)config);
        JaasAuthorityGranter jaasAuthorityGranter = new JaasAuthorityGranter(jaasConfig.getGroupsToRolesMappingConfig());
        authProvider.setAuthorityGranters(new AuthorityGranter[]{jaasAuthorityGranter});
        try {
            authProvider.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new SecurityConfigApiException("JAAS configuration failed: " + e.getMessage(), (Throwable)e);
        }
        return authProvider;
    }

    @ConstructorProperties(value={"persistentJaasConfig"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JaasSecurityProvider(PersistentJaasConfig persistentJaasConfig) {
        this.persistentJaasConfig = persistentJaasConfig;
    }
}

