/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.builtin;

import com.hazelcast.webmonitor.config.properties.SecurityDictionaryConfigurationProperties;
import com.hazelcast.webmonitor.security.spi.impl.builtin.PasswordStrengthChecker;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class PasswordStrengthChecker {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordStrengthChecker.class);
    private static final Pattern SPECIAL_CHARACTER_PATTERN = Pattern.compile(".*?[^a-zA-Z0-9 ].*");
    private static final int MIN_PASSWORD_LENGTH = 8;
    private static final int MIN_NUMBER_OF_CHARACTER_GROUPS = 2;
    private final File dictionary;
    private final boolean dictionaryEnabled;
    private final int dictMinWordLength;

    public PasswordStrengthChecker() {
        this(null, 0);
    }

    public PasswordStrengthChecker(Path dictionaryPath, int minWordLength) {
        if (dictionaryPath != null) {
            this.dictMinWordLength = minWordLength;
            this.dictionary = dictionaryPath.toFile();
            if (!this.dictionary.exists()) {
                log.warn("Provided dictionary file path [{}] not found. User passwords will not be checked against a dictionary.", (Object)dictionaryPath);
                this.dictionaryEnabled = false;
            } else {
                log.info("Using dictionary file at [{}] with a minimum word length of {} for password checking.", (Object)dictionaryPath, (Object)this.dictMinWordLength);
                this.dictionaryEnabled = true;
            }
        } else {
            this.dictionary = null;
            this.dictionaryEnabled = false;
            this.dictMinWordLength = 0;
        }
    }

    @Autowired
    public PasswordStrengthChecker(SecurityDictionaryConfigurationProperties properties) {
        this(properties.getPath(), properties.getMinWordLength());
    }

    EnumSet<Violation> check(String username, String password) {
        assert (!StringUtil.isNullOrEmptyAfterTrim((String)username));
        assert (!StringUtil.isNullOrEmptyAfterTrim((String)password));
        EnumSet<Violation> violations = EnumSet.noneOf(Violation.class);
        if (password.length() < 8) {
            violations.add(Violation.MIN_LENGTH);
        }
        if (StringUtil.containsIgnoreCase((String)password, (String)username)) {
            violations.add(Violation.CONTAINS_USERNAME);
        }
        if (!PasswordStrengthChecker.containsEnoughCharacterGroups((String)password)) {
            violations.add(Violation.CHARACTER_GROUPS);
        }
        if (PasswordStrengthChecker.containsRepeatingCharacters((String)password)) {
            violations.add(Violation.REPEATING_CHARACTERS);
        }
        if (PasswordStrengthChecker.containsSequentialLetters((String)password)) {
            violations.add(Violation.SEQUENTIAL_LETTERS);
        }
        if (PasswordStrengthChecker.containsSequentialDigits((String)password)) {
            violations.add(Violation.SEQUENTIAL_DIGITS);
        }
        if (this.containsDictionaryWord(password)) {
            violations.add(Violation.CONTAINS_DICTIONARY_WORD);
        }
        return violations;
    }

    private static boolean containsEnoughCharacterGroups(String password) {
        boolean hasAlpha = false;
        boolean hasNumeral = false;
        boolean hasSpecialChars = SPECIAL_CHARACTER_PATTERN.matcher(password).matches();
        for (int i = 0; i < password.length(); ++i) {
            char currentChar = password.charAt(i);
            hasAlpha |= Character.isLetter(currentChar);
            hasNumeral |= Character.isDigit(currentChar);
        }
        int numberOfCharacterGroups = 0;
        if (hasAlpha) {
            ++numberOfCharacterGroups;
        }
        if (hasNumeral) {
            ++numberOfCharacterGroups;
        }
        if (hasSpecialChars) {
            ++numberOfCharacterGroups;
        }
        return numberOfCharacterGroups >= 2;
    }

    private static boolean containsRepeatingCharacters(String password) {
        int repeatLength = 0;
        for (int i = 1; i < password.length(); ++i) {
            char curr;
            char prev = password.charAt(i - 1);
            if (prev == (curr = password.charAt(i)) || Character.isLetter(prev) && Character.isLetter(curr) && Character.toLowerCase(prev) == Character.toLowerCase(curr)) {
                if (++repeatLength != 2) continue;
                return true;
            }
            repeatLength = 0;
        }
        return false;
    }

    private static boolean containsSequentialLetters(String password) {
        int fwdSequenceLength = 0;
        int backSequenceLength = 0;
        for (int i = 1; i < password.length(); ++i) {
            char curr = password.charAt(i);
            char prev = password.charAt(i - 1);
            if (Character.isLetter(curr) && Character.isLetter(prev)) {
                if (Character.toLowerCase(curr) - Character.toLowerCase(prev) == 1) {
                    ++fwdSequenceLength;
                    backSequenceLength = 0;
                } else if (Character.toLowerCase(prev) - Character.toLowerCase(curr) == 1) {
                    ++backSequenceLength;
                    fwdSequenceLength = 0;
                } else {
                    fwdSequenceLength = 0;
                    backSequenceLength = 0;
                }
                if (fwdSequenceLength != 2 && backSequenceLength != 2) continue;
                return true;
            }
            fwdSequenceLength = 0;
            backSequenceLength = 0;
        }
        return false;
    }

    private static boolean containsSequentialDigits(String password) {
        int fwdSequenceLength = 0;
        int backSequenceLength = 0;
        for (int i = 1; i < password.length(); ++i) {
            char curr = password.charAt(i);
            char prev = password.charAt(i - 1);
            if (Character.isDigit(curr) && Character.isDigit(prev)) {
                if (curr - prev == 1) {
                    ++fwdSequenceLength;
                    backSequenceLength = 0;
                } else if (prev - curr == 1) {
                    ++backSequenceLength;
                    fwdSequenceLength = 0;
                } else {
                    fwdSequenceLength = 0;
                    backSequenceLength = 0;
                }
                if (fwdSequenceLength != 2 && backSequenceLength != 2) continue;
                return true;
            }
            fwdSequenceLength = 0;
            backSequenceLength = 0;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsDictionaryWord(String password) {
        if (!this.dictionaryEnabled) {
            return false;
        }
        try (BufferedReader br = Files.newBufferedReader(this.dictionary.toPath(), StandardCharsets.UTF_8);){
            String line;
            do {
                if ((line = br.readLine()) == null) return false;
            } while (line.length() < this.dictMinWordLength || !StringUtil.containsIgnoreCase((String)password, (String)line));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("IOException occurred while reading from dictionary path [" + this.dictionary.getAbsolutePath() + "]", (Throwable)e);
        }
        return false;
    }
}

