/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl;

import com.hazelcast.webmonitor.config.properties.ADConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.LdapConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.ScriptDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserCredentialsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerConfig;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.security.spi.impl.DisableLoginStrategy;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigImportService;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderEventListener;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.ActiveDirectorySecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.PersistentActiveDirectoryConfig;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DevModeSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.builtin.PasswordStrengthChecker;
import com.hazelcast.webmonitor.security.spi.impl.jaas.JaasSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.jaas.PersistentJaasConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.oidc.PersistentOidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.PersistentSamlConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlConfigMigrator;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlSecurityProvider;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.service.CloudIntegrationService;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthenticationManagerConfig {
    private final Jdbi jdbi;
    private final UserDAO userDAO;
    private final UserCredentialsDAO userCredDAO;
    private final ScriptDAO scriptDAO;
    private final GroupedSettingsDAO groupedSettingsDAO;
    private final SettingsDAO settingsDAO;
    private final SecurityConfigImportService importedProps;
    private final AuthTokenManager authTokenManager;
    private final AuthTokenDAO authTokenDAO;
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final JdbiHistories histories;
    private final MCConfigurationProperties mcProperties;
    private final LdapConfigurationProperties ldapProperties;
    private final ADConfigurationProperties adProperties;
    private final Optional<CloudIntegrationService> cloudIntegrationService;

    @Bean
    public SecurityConfigurationManager configManager(Collection<SecurityProviderEventListener> listeners) {
        return new SecurityConfigurationManager(this.settingsDAO, listeners);
    }

    @Bean
    public PersistentSamlConfig persistentSamlConfig() {
        return new PersistentSamlConfig(this.groupedSettingsDAO);
    }

    @Bean
    public SamlConfigMigrator samlConfigMigrator(SecurityConfigurationManager configurationManager, PersistentSamlConfig persistentSamlConfig) {
        return new SamlConfigMigrator(this.homeDirectoryProvider, persistentSamlConfig, configurationManager);
    }

    @Bean
    public AuthenticationManagerImpl authenticationManagerImpl(Collection<SecurityProviderEventListener> listeners, DisableLoginStrategy disableLoginStrategy, PasswordStrengthChecker passwordStrengthChecker) {
        return new AuthenticationManagerImpl(this.configManager(listeners), disableLoginStrategy, Arrays.asList(this.devModeProvider(), this.defaultProvider(passwordStrengthChecker), this.activeDirectoryProvider(), this.jaasProvider(), this.ldapProvider(), this.samlProvider(), this.oidcProvider()));
    }

    private DefaultSecurityProvider defaultProvider(PasswordStrengthChecker passwordStrengthChecker) {
        return new DefaultSecurityProvider(this.jdbi, this.userDAO, this.userCredDAO, this.scriptDAO, this.authTokenDAO, this.histories, passwordStrengthChecker, this.authTokenManager, (CloudIntegrationService)this.cloudIntegrationService.orElse(null));
    }

    private JaasSecurityProvider jaasProvider() {
        return new JaasSecurityProvider(new PersistentJaasConfig(this.groupedSettingsDAO));
    }

    private LdapSecurityProvider ldapProvider() {
        return new LdapSecurityProvider(this.homeDirectoryProvider, this.jdbi, this.groupedSettingsDAO, this.importedProps, this.mcProperties, this.ldapProperties);
    }

    private ActiveDirectorySecurityProvider activeDirectoryProvider() {
        return new ActiveDirectorySecurityProvider(new PersistentActiveDirectoryConfig(this.groupedSettingsDAO), this.importedProps, this.ldapProperties.getTimeout(), this.adProperties);
    }

    private OidcSecurityProvider oidcProvider() {
        return new OidcSecurityProvider(new PersistentOidcConfig(this.groupedSettingsDAO));
    }

    private DevModeSecurityProvider devModeProvider() {
        return new DevModeSecurityProvider();
    }

    private SamlSecurityProvider samlProvider() {
        return new SamlSecurityProvider(this.persistentSamlConfig());
    }

    @ConstructorProperties(value={"jdbi", "userDAO", "userCredDAO", "scriptDAO", "groupedSettingsDAO", "settingsDAO", "importedProps", "authTokenManager", "authTokenDAO", "homeDirectoryProvider", "histories", "mcProperties", "ldapProperties", "adProperties", "cloudIntegrationService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    AuthenticationManagerConfig(Jdbi jdbi, UserDAO userDAO, UserCredentialsDAO userCredDAO, ScriptDAO scriptDAO, GroupedSettingsDAO groupedSettingsDAO, SettingsDAO settingsDAO, SecurityConfigImportService importedProps, AuthTokenManager authTokenManager, AuthTokenDAO authTokenDAO, HomeDirectoryProvider homeDirectoryProvider, JdbiHistories histories, MCConfigurationProperties mcProperties, LdapConfigurationProperties ldapProperties, ADConfigurationProperties adProperties, Optional<CloudIntegrationService> cloudIntegrationService) {
        this.jdbi = jdbi;
        this.userDAO = userDAO;
        this.userCredDAO = userCredDAO;
        this.scriptDAO = scriptDAO;
        this.groupedSettingsDAO = groupedSettingsDAO;
        this.settingsDAO = settingsDAO;
        this.importedProps = importedProps;
        this.authTokenManager = authTokenManager;
        this.authTokenDAO = authTokenDAO;
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.histories = histories;
        this.mcProperties = mcProperties;
        this.ldapProperties = ldapProperties;
        this.adProperties = adProperties;
        this.cloudIntegrationService = cloudIntegrationService;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static AuthenticationManagerConfigBuilder builder() {
        return new AuthenticationManagerConfigBuilder();
    }
}

