/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi;

import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;

public final class SecurityConfigParameter {
    private final Type type;
    private final String name;
    private final String display;
    private final String defaultValue;

    private SecurityConfigParameter(Type type, String name, String display, String defaultValue) {
        this.type = type;
        this.name = name;
        this.display = display;
        this.defaultValue = defaultValue;
    }

    public static SecurityConfigParameter secretParam(String name, String display) {
        return new SecurityConfigParameter(Type.SECRET, name, display, null);
    }

    public static SecurityConfigParameter stringParam(String name, String display, String defaultValue) {
        return new SecurityConfigParameter(Type.TEXT, name, display, defaultValue);
    }

    public static SecurityConfigParameter stringParam(String name, String display) {
        return new SecurityConfigParameter(Type.TEXT, name, display, null);
    }

    public static SecurityConfigParameter boolParam(String name, String display) {
        return new SecurityConfigParameter(Type.BOOLEAN, name, display, null);
    }

    public static SecurityConfigParameter boolParam(String name, String display, boolean defaultValue) {
        return new SecurityConfigParameter(Type.BOOLEAN, name, display, String.valueOf(defaultValue));
    }

    public String getName() {
        return this.name;
    }
}

