/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.controller.dto.ApiErrorDTO;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Service;

@Service
public class BearerTokenAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BearerTokenAuthenticationFailureHandler.class);
    private final AuditLogService auditService;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        log.debug(exception.getMessage(), (Throwable)exception);
        String username = request.getParameter("username");
        this.auditService.log(AuditableEvent.builder().typeId("MC-2006 [Auth]").message("Detected failed bearer token log in attempt").parameter("username", (Object)(username != null ? username : "N/A")).cause((Throwable)exception).build());
        ApiErrorDTO apiError = new ApiErrorDTO("UNAUTHORIZED", exception.getMessage());
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write(SerializationUtil.OBJECT_MAPPER.writeValueAsString((Object)apiError));
    }

    @ConstructorProperties(value={"auditService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BearerTokenAuthenticationFailureHandler(AuditLogService auditService) {
        this.auditService = auditService;
    }
}

