/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.TablePresetModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Service;

@Service
public class TablePresetDAO {
    private final Jdbi jdbi;
    private static final String SELECT_BY_TABLE_ID = "SELECT p.id             p_id, p.table_id       p_table_id, p.name           p_name, p.readonly       p_readonly, p.current        p_current, c.column_name    column_name FROM table_presets p LEFT JOIN table_preset_columns c ON p.id = c.preset_id WHERE table_id = :table_id";

    public List<TablePresetModel> findPresetsByTableId(String tableId) {
        return (List)this.jdbi.withHandle(handle -> this.findByTableIdTx(handle, tableId));
    }

    private List<TablePresetModel> findByTableIdTx(Handle handle, String tableId) {
        try (Query query = handle.createQuery(SELECT_BY_TABLE_ID);){
            List<TablePresetModel> list = ((Query)((Query)query.bind("table_id", tableId)).registerRowMapper(BeanMapper.factory(TablePresetModel.class, (String)"p"))).reduceRows((map, rowView) -> {
                TablePresetModel preset = map.computeIfAbsent((String)rowView.getColumn("id", String.class), id -> (TablePresetModel)rowView.getRow(TablePresetModel.class));
                String colName = (String)rowView.getColumn("column_name", String.class);
                if (colName != null) {
                    preset.getHiddenColumns().add(colName);
                }
            }).collect(Collectors.toList());
            return list;
        }
    }

    public void insertOrUpdate(String tableId, List<TablePresetModel> presets) {
        this.jdbi.inTransaction(handle -> {
            this.deleteAllPresetsOfTableTx(handle, tableId);
            presets.forEach(preset -> this.insertTx(handle, tableId, preset));
            return null;
        });
    }

    private void insertTx(Handle handle, String tableId, TablePresetModel preset) {
        handle.useTransaction(h -> {
            ((Update)((Update)h.createUpdate("INSERT INTO table_presets (table_id, id, name, readonly, current) VALUES (:given_table_id, :id, :name, :readonly, :current)").bindBean((Object)preset)).bind("given_table_id", tableId)).execute();
            PreparedBatch batch = h.prepareBatch("INSERT INTO table_preset_columns (preset_id, column_name) VALUES(:preset_id, :column_name)");
            preset.getHiddenColumns().forEach(columnName -> ((PreparedBatch)((PreparedBatch)batch.bind("preset_id", preset.getId())).bind("column_name", columnName)).add());
            batch.execute();
        });
    }

    private void deleteAllPresetsOfTableTx(Handle handle, String tableId) {
        try (Update update = handle.createUpdate("DELETE FROM table_presets WHERE table_id = :table_id");){
            ((Update)update.bind("table_id", tableId)).execute();
        }
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TablePresetDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

