/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.HealthCheckIgnoreListEntry;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreListEntryAlreadyExistsException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;

public class HealthCheckIgnoreListDAO {
    private final Jdbi jdbi;

    public synchronized void insertEntry(HealthCheckIgnoreListEntry ignoreListEntry) throws IgnoreListEntryAlreadyExistsException {
        Long count = (Long)this.jdbi.withHandle(h -> (Long)((Query)h.createQuery("SELECT count(*) FROM healthcheck_ignorelist WHERE description = :description AND advice = :advice AND cluster = :cluster").bindBean((Object)ignoreListEntry)).mapTo(Long.class).one());
        if (count != 0L) {
            throw new IgnoreListEntryAlreadyExistsException(ignoreListEntry);
        }
        this.jdbi.useHandle(h -> ((Update)h.createUpdate("INSERT INTO healthcheck_ignorelist  (description, advice, ignored_by, cluster)  VALUES (:description, :advice, :ignoredBy, :cluster)").bindBean((Object)ignoreListEntry)).execute());
    }

    public List<HealthCheckIgnoreListEntry> queryIgnoreList(String cluster) {
        return (List)this.jdbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM healthcheck_ignorelist  WHERE cluster = :cluster").bind("cluster", cluster)).mapToBean(HealthCheckIgnoreListEntry.class).list());
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthCheckIgnoreListDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

