/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.security.AuthTokenModel;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthTokenDAO {
    private final Jdbi jdbi;

    @Autowired
    public AuthTokenDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public Optional<AuthTokenModel> findByHash(String tokenHash) {
        return (Optional)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select * from auth_tokens where token_hash = :tokenHash").bind("tokenHash", tokenHash)).mapToBean(AuthTokenModel.class).findFirst());
    }

    public List<AuthTokenModel> findAllForUser(String username) {
        return (List)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select * from auth_tokens where username = :username").bind("username", username)).mapToBean(AuthTokenModel.class).list());
    }

    public void insert(AuthTokenModel token) {
        this.jdbi.withHandle(handle -> ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("insert into auth_tokens (token_hash, username, label, roles, issued_at) values (:tokenHash, :username, :label, :roles, :issuedAt)").bind("tokenHash", token.getTokenHash())).bind("username", token.getUsername())).bind("label", token.getLabel())).bind("roles", token.getRoles())).bind("issuedAt", (Object)token.getIssuedAt())).execute());
    }

    public int revokeSingleToken(String tokenHash) {
        return (Integer)this.jdbi.withHandle(handle -> ((Update)handle.createUpdate("delete from auth_tokens where token_hash = :tokenHash").bind("tokenHash", tokenHash)).execute());
    }

    public int revokeAllUserTokens(String username) {
        return (Integer)this.jdbi.withHandle(handle -> this.revokeAllUserTokensTx(handle, username));
    }

    public int revokeAllUserTokensTx(Handle handle, String username) {
        return ((Update)handle.createUpdate("delete from auth_tokens where username = :username").bind("username", username)).execute();
    }
}

