/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.jet.tagexpressions;

import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class RegexpExpression
implements TagExpression {
    private final String tag;
    private final Pattern valueRegexp;

    public RegexpExpression(String tag, String valueRegexp) {
        this.tag = tag;
        this.valueRegexp = Pattern.compile(valueRegexp);
    }

    public boolean matches(Map<String, String> parsedTags) {
        String v = parsedTags.get(this.tag);
        return v != null && this.valueRegexp.matcher(v).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexpExpression that = (RegexpExpression)o;
        return Objects.equals(this.tag, that.tag) && this.valueRegexp.pattern().equals(that.valueRegexp.pattern());
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.valueRegexp.pattern());
    }

    public String toString() {
        return this.tag + "=regexp(" + this.valueRegexp + ')';
    }
}

