/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.utils;

import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.impl.utils.ValueUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class DataPointSeriesBuilder {
    private final DataPointType type;
    private final long rangeStart;
    private final long rangeEnd;
    private final List<long[]> timeFragments = new ArrayList();
    private final List<long[]> valueFragments = new ArrayList();
    private int pointsCount;

    public DataPointSeriesBuilder(long rangeStart, long rangeEnd, DataPointType type) {
        if (rangeStart > rangeEnd) {
            throw new IllegalArgumentException("Range start must not be later than range end");
        }
        this.type = type;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public DataPointSeriesBuilder append(long[] times, long[] values) {
        Objects.requireNonNull(times, "Times array must be set");
        Objects.requireNonNull(values, "Values array must be set");
        if (values.length != times.length) {
            throw new IllegalArgumentException("Time and value array sizes must match");
        }
        this.timeFragments.add(times);
        this.valueFragments.add(values);
        for (int i = 0; i < times.length; ++i) {
            if (ValueUtil.isMissingValue((long)values[i]) || !this.isTimeWithinRange(times[i])) continue;
            ++this.pointsCount;
        }
        return this;
    }

    private boolean isTimeWithinRange(long time) {
        return time >= this.rangeStart && time <= this.rangeEnd;
    }

    public DataPointSeries build() {
        long[] times = new long[this.pointsCount];
        long[] values = new long[this.pointsCount];
        int pos = 0;
        Iterator timesFragIt = this.timeFragments.iterator();
        Iterator valuesFragIt = this.valueFragments.iterator();
        while (pos < this.pointsCount) {
            long[] timesFrag = (long[])timesFragIt.next();
            long[] valuesFrag = (long[])valuesFragIt.next();
            for (int i = 0; i < valuesFrag.length; ++i) {
                if (ValueUtil.isMissingValue((long)valuesFrag[i]) || !this.isTimeWithinRange(timesFrag[i])) continue;
                times[pos] = timesFrag[i];
                values[pos] = valuesFrag[i];
                ++pos;
            }
        }
        return new DataPointSeries(times, values, this.type);
    }
}

