/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.serde;

import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.metrics.impl.MetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.serde.ByteArrayInput;
import com.hazelcast.webmonitor.metrics.impl.serde.ByteArrayOutput;
import com.hazelcast.webmonitor.metrics.impl.serde.Serde;

public class RegistryKeySerde
extends Serde<MetricsRegistry.RegistryKey, MetricsRegistry.RegistryKey> {
    protected void doSerialize(ByteArrayOutput out, MetricsRegistry.RegistryKey value) {
        out.writeBoolean(value.isNil());
        if (value.isNil()) {
            return;
        }
        out.writeUTF(value.getName());
        out.writeInt(value.getTags().size());
        for (Tags.Tag tag : value.getTags()) {
            out.writeUTF(tag.getName());
            out.writeUTF(tag.getValue());
        }
    }

    protected MetricsRegistry.RegistryKey doDeserialize(ByteArrayInput in) {
        if (in.readBoolean()) {
            return MetricsRegistry.RegistryKey.nil();
        }
        String metricName = in.readUTF();
        int tagsSize = in.readInt();
        String[] names = new String[tagsSize];
        String[] values = new String[tagsSize];
        for (int i = 0; i < tagsSize; ++i) {
            names[i] = in.readUTF();
            values[i] = in.readUTF();
        }
        Tags tags = new Tags(names, values);
        return new MetricsRegistry.RegistryKey(metricName, tags);
    }
}

