/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.serde;

import com.hazelcast.webmonitor.metrics.impl.serde.ByteArrayInput;
import com.hazelcast.webmonitor.metrics.impl.serde.ByteArrayOutput;
import com.hazelcast.webmonitor.metrics.impl.serde.Serde;
import com.hazelcast.webmonitor.metrics.impl.utils.ByteUtil;
import com.hazelcast.webmonitor.metrics.impl.utils.ValueUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLongArray;

public class MinuteSeriesSerde
extends Serde<AtomicLongArray, long[]> {
    private static final int BITMAP_SIZE_BYTES = 8;
    private static final int BITMAP_SIZE_BITS = 64;

    protected void doSerialize(ByteArrayOutput out, AtomicLongArray minuteValues) {
        if (minuteValues.length() != 60) {
            throw new IllegalArgumentException("Only minute values are supported");
        }
        long[] seriesValues = new long[minuteValues.length()];
        byte seriesPtr = 0;
        BitSet bitmap = new BitSet(64);
        for (int i = 0; i < minuteValues.length(); ++i) {
            long value = minuteValues.get(i);
            if (ValueUtil.isMissingValue((long)value)) continue;
            byte by = seriesPtr;
            seriesPtr = (byte)(seriesPtr + 1);
            seriesValues[by] = value;
            bitmap.set(i);
        }
        out.writeByte(seriesPtr);
        if (seriesPtr == 0) {
            return;
        }
        if (seriesPtr < 60) {
            byte[] mask = this.maskToBytes(bitmap);
            out.writeByteArray(mask);
        }
        byte[] payload = ByteUtil.deltaCompress((long[])seriesValues, (int)seriesPtr);
        out.writeByteArray(payload);
    }

    protected long[] doDeserialize(ByteArrayInput in) {
        byte seriesSize = in.readByte();
        if (seriesSize == 0) {
            return ValueUtil.emptyMinuteBucket();
        }
        if (seriesSize == 60) {
            byte[] payload = new byte[in.size() - 1];
            in.readByteArray(payload);
            return ByteUtil.deltaUncompress((byte[])payload, (int)seriesSize);
        }
        byte[] mask = new byte[8];
        in.readByteArray(mask);
        byte[] payload = new byte[in.size() - 8 - 1];
        in.readByteArray(payload);
        long[] seriesValues = ByteUtil.deltaUncompress((byte[])payload, (int)seriesSize);
        BitSet bitmap = BitSet.valueOf(mask);
        long[] minuteValues = ValueUtil.emptyMinuteBucket();
        int exPos = 0;
        for (int i = 0; i < minuteValues.length; ++i) {
            if (!bitmap.get(i)) continue;
            int n = exPos;
            exPos = (byte)(exPos + 1);
            minuteValues[i] = seriesValues[n];
        }
        return minuteValues;
    }

    private byte[] maskToBytes(BitSet bitMask) {
        byte[] maskBytes = bitMask.toByteArray();
        int size = Math.max(maskBytes.length, 8);
        return Arrays.copyOf(maskBytes, size);
    }
}

