/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.metrics.impl.InternalStorageException;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.Paths;
import lombok.Generated;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RocksDBLoader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBLoader.class);
    private static final String ROCKSDB_SHARED_LIB_DIR_ENV_VARIABLE = "ROCKSDB_SHAREDLIB_DIR";

    private RocksDBLoader() {
    }

    public static void loadLibrary() throws InternalStorageException.InternalLoadNativeException {
        RocksDBLoader.assertThatRocksDBSharedLibDirIsWritable();
        try {
            RocksDB.loadLibrary();
        }
        catch (Throwable e) {
            log.error("RocksDB library load error", e);
            throw new InternalStorageException.InternalLoadNativeException(String.format("Could not load RocksDB. It may be a permission issue, please check `java.io.tmpdir` permissions or pass an explicit %s param. You may be using an unsupported OS or architecture. See https://docs.hazelcast.com/management-center/%s/getting-started/overview#system-requirements", "ROCKSDB_SHAREDLIB_DIR", BuildInfo.getVersionForDocs()), e);
        }
    }

    private static void assertThatRocksDBSharedLibDirIsWritable() {
        String rocksDBSharedLibDir = System.getenv("ROCKSDB_SHAREDLIB_DIR");
        if (StringUtil.isNullOrEmptyAfterTrim((String)rocksDBSharedLibDir)) {
            rocksDBSharedLibDir = System.getProperty("java.io.tmpdir");
        }
        log.debug("'{}' is used as RocksDB shared library directory", (Object)rocksDBSharedLibDir);
        if (!Files.isWritable(Paths.get(rocksDBSharedLibDir, new String[0]))) {
            log.error("[{}] is not writable which means metrics cannot be stored.\nPlease set {} env variable to a writable directory and restart Management Center\nFor more details check reference manual at\n\thttps://docs.hazelcast.com/management-center/{}/deploy-manage/historical-metrics#rocksdb-file-permissions\n", new Object[]{rocksDBSharedLibDir, "ROCKSDB_SHAREDLIB_DIR", BuildInfo.getVersionForDocs()});
            throw new Error(rocksDBSharedLibDir + " is not writable");
        }
    }
}

