/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl;

import com.hazelcast.webmonitor.metrics.impl.InternalStorageException;
import com.hazelcast.webmonitor.metrics.impl.MinuteBucket;
import com.hazelcast.webmonitor.metrics.impl.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.PassiveExpiringSet;
import com.hazelcast.webmonitor.metrics.impl.PersistentStore;
import com.hazelcast.webmonitor.metrics.impl.RawDataPoint;
import com.hazelcast.webmonitor.metrics.impl.utils.TimeUtil;
import com.hazelcast.webmonitor.metrics.impl.utils.ValueUtil;
import com.hazelcast.webmonitor.service.Clock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStoreManager
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersistentStoreManager.class);
    private final PersistentStore store;
    private final PassiveExpiringSet<MinuteBucket> trackedEntries;
    private final AtomicLong persistedBucketsCount = new AtomicLong();
    private volatile boolean closed;

    public PersistentStoreManager(Clock clock, int initialTrackedSetSize, PersistentStore store, Duration accumulationPeriod) {
        this.trackedEntries = new PassiveExpiringSet(clock, accumulationPeriod.toNanos(), initialTrackedSetSize);
        this.store = store;
    }

    public long[] getPersistedValue(MinuteStartId minStartId) throws InternalStorageException {
        return this.store.get(minStartId);
    }

    public RawDataPoint getLatestPersistedPoint(MinuteStartId minStartId, long endTime) throws InternalStorageException {
        long[] values = this.store.get(minStartId);
        if (values != null) {
            for (int i = values.length - 1; i > -1; --i) {
                long time;
                long value = values[i];
                if (ValueUtil.isMissingValue((long)value) || (time = TimeUtil.minuteTimePoint((long)minStartId.getTime(), (int)i)) > endTime) continue;
                return new RawDataPoint(TimeUtil.minuteTimePoint((long)minStartId.getTime(), (int)i), value);
            }
        }
        return null;
    }

    public void track(MinuteBucket bucket) {
        if (this.closed) {
            return;
        }
        this.trackedEntries.put(bucket);
    }

    public int persistExpired() {
        if (this.closed) {
            return 0;
        }
        List expiredBuckets = this.trackedEntries.pollExpired();
        this.persist(expiredBuckets);
        return expiredBuckets.size();
    }

    public void persistAll() {
        if (this.closed) {
            return;
        }
        List allBuckets = this.trackedEntries.pollAll();
        this.persist(allBuckets);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(List<MinuteBucket> buckets) {
        if (buckets.isEmpty()) {
            return;
        }
        int size = buckets.size();
        try {
            this.store.putAll(buckets);
            this.persistedBucketsCount.addAndGet(size);
        }
        catch (Exception e) {
            log.warn("Could not persist {} minute buckets.", (Object)size, (Object)e);
        }
        finally {
            buckets.forEach(MinuteBucket::release);
        }
    }

    int getTrackedSetSize() {
        return this.trackedEntries.size();
    }

    long getPersistedMinuteBucketsCount() {
        return this.persistedBucketsCount.get();
    }
}

