/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.MetricAware;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.StorageException;
import com.hazelcast.webmonitor.metrics.impl.EmbeddedMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.InMemoryCache;
import com.hazelcast.webmonitor.metrics.impl.InternalStorageException;
import com.hazelcast.webmonitor.metrics.impl.MetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.MinuteBucket;
import com.hazelcast.webmonitor.metrics.impl.MinuteSeries;
import com.hazelcast.webmonitor.metrics.impl.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.PersistentStore;
import com.hazelcast.webmonitor.metrics.impl.PersistentStoreManager;
import com.hazelcast.webmonitor.metrics.impl.RawDataPoint;
import com.hazelcast.webmonitor.metrics.impl.utils.DataPointSeriesBuilder;
import com.hazelcast.webmonitor.metrics.impl.utils.TimeUtil;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageStatsCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedMetricsStorage
implements MetricsStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMetricsStorage.class);
    private static final int INITIAL_IN_MEMORY_METRICS_CACHE_SIZE = 300000;
    private static final int EXECUTOR_TERMINATION_TIMEOUT_MS = 20000;
    private final MetricsRegistry metricsRegistry;
    private final InMemoryCache inMemoryCache;
    private final int persistenceRunsInterval;
    private final PersistentStoreManager persistentStoreManager;
    private final ScheduledExecutorService persistenceRunsExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "MetricsPersistence"));
    private final MetricsStorageStatsCounter statsCounter;
    private volatile boolean closed;

    public EmbeddedMetricsStorage(MetricsStorageStatsCounter statsCounter, Clock clock, MetricsRegistry metricsRegistry, PersistentStore persistentStore, int persistenceRunsInterval, Duration accumulationPeriod) {
        this.inMemoryCache = new InMemoryCache(statsCounter, 300000);
        this.statsCounter = statsCounter;
        this.persistenceRunsInterval = persistenceRunsInterval;
        this.metricsRegistry = metricsRegistry;
        this.persistentStoreManager = new PersistentStoreManager(clock, 300000, persistentStore, accumulationPeriod);
        this.persistenceRunsExecutor.scheduleAtFixedRate((Runnable)new PersistenceRunnable(this, null), this.persistenceRunsInterval, this.persistenceRunsInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(Collection<MetricDataPoint> dataPoints) {
        if (dataPoints == null) {
            throw new IllegalArgumentException("Data points collection must be set");
        }
        if (this.closed) {
            throw new StorageException.ClosedStorageException();
        }
        try {
            for (MetricDataPoint dataPoint : dataPoints) {
                MinuteSeries minuteSeries;
                int metricId = this.metricsRegistry.register(new MetricsRegistry.RegistryKey((MetricAware)dataPoint), dataPoint.getType()).getId();
                MinuteSeries minuteSeries2 = minuteSeries = this.inMemoryCache.getMinuteSeries(metricId);
                synchronized (minuteSeries2) {
                    MinuteBucket bucket = minuteSeries.put(metricId, dataPoint.getTime(), dataPoint.getValue());
                    if (bucket == null) {
                        this.statsCounter.incrementDroppedDataPoints();
                        continue;
                    }
                    this.persistentStoreManager.track(bucket);
                }
            }
            return;
        }
        catch (InternalStorageException e) {
            throw e.toPublicException();
        }
        catch (Exception e) {
            throw new StorageException.UnexpectedException((Throwable)e);
        }
    }

    public DataPointSeries queryRange(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (this.closed) {
            throw new StorageException.ClosedStorageException();
        }
        try {
            long[] minStarts;
            MetricsRegistry.RegistryValue registryValue = this.metricsRegistry.get(new MetricsRegistry.RegistryKey((MetricAware)query));
            if (registryValue == null) {
                return DataPointSeries.empty();
            }
            int metricId = registryValue.getId();
            DataPointSeriesBuilder builder = new DataPointSeriesBuilder(query.getStart(), query.getEnd(), registryValue.getType());
            for (long minStart : minStarts = TimeUtil.minuteStarts((long)query.getStart(), (long)query.getEnd())) {
                MinuteStartId minStartId = new MinuteStartId(metricId, minStart);
                long[] values = this.inMemoryCache.get(minStartId);
                if (values == null) {
                    values = this.persistentStoreManager.getPersistedValue(minStartId);
                }
                if (values == null) continue;
                long[] times = TimeUtil.minuteTimePoints((long)minStart);
                builder.append(times, values);
            }
            return builder.build();
        }
        catch (InternalStorageException e) {
            throw e.toPublicException();
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException.UnexpectedException((Throwable)e);
        }
    }

    public Optional<DataPointAware> queryLatest(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (this.closed) {
            throw new StorageException.ClosedStorageException();
        }
        try {
            long start = TimeUtil.minuteStart((long)query.getStart());
            long ptr = TimeUtil.minuteStart((long)query.getEnd());
            MetricsRegistry.RegistryValue registryValue = this.metricsRegistry.get(new MetricsRegistry.RegistryKey((MetricAware)query));
            if (registryValue == null) {
                return Optional.empty();
            }
            int metricId = registryValue.getId();
            while (ptr >= start) {
                MinuteStartId minStartId = new MinuteStartId(metricId, ptr);
                RawDataPoint rawDataPoint = this.inMemoryCache.getLatest(minStartId, query.getEnd());
                if (rawDataPoint == null) {
                    rawDataPoint = this.persistentStoreManager.getLatestPersistedPoint(minStartId, query.getEnd());
                }
                if (rawDataPoint != null && rawDataPoint.time >= query.getStart()) {
                    return Optional.of(rawDataPoint.convert(registryValue.getType()));
                }
                ptr = TimeUtil.prevMinuteStart((long)ptr);
            }
            return Optional.empty();
        }
        catch (InternalStorageException e) {
            throw e.toPublicException();
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException.UnexpectedException((Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.closed = true;
            this.persistenceRunsExecutor.shutdown();
            this.persistenceRunsExecutor.awaitTermination(20000L, TimeUnit.MILLISECONDS);
            this.persistentStoreManager.persistAll();
        }
        catch (Exception e) {
            log.error("Could not close metrics storage.", (Throwable)e);
        }
        finally {
            this.metricsRegistry.close();
            this.persistentStoreManager.close();
            this.inMemoryCache.close();
        }
    }

    void resetInMemoryStore() {
        this.inMemoryCache.reset();
    }

    public int getMetricsRegistrySize() {
        return this.metricsRegistry.size();
    }

    public long getTrackedMinuteBucketsCount() {
        return this.persistentStoreManager.getTrackedSetSize();
    }

    public long getPersistedMinuteBucketsCount() {
        return this.persistentStoreManager.getPersistedMinuteBucketsCount();
    }

    static /* synthetic */ int access$100(EmbeddedMetricsStorage x0) {
        return x0.persistenceRunsInterval;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ PersistentStoreManager access$300(EmbeddedMetricsStorage x0) {
        return x0.persistentStoreManager;
    }

    static /* synthetic */ MetricsStorageStatsCounter access$400(EmbeddedMetricsStorage x0) {
        return x0.statsCounter;
    }
}

