/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.imdg.ImdgMetricAwareBuilder;

public class ImdgQueryBuilder
extends ImdgMetricAwareBuilder<ImdgQueryBuilder, Query> {
    private static final long MISSING_TIME = Long.MIN_VALUE;
    private long start = Long.MIN_VALUE;
    private long end = Long.MIN_VALUE;

    protected ImdgQueryBuilder self() {
        return this;
    }

    public ImdgQueryBuilder start(long start) {
        this.start = start;
        return this;
    }

    public ImdgQueryBuilder end(long end) {
        this.end = end;
        return this;
    }

    public Query build() {
        if (this.start == Long.MIN_VALUE || this.end == Long.MIN_VALUE) {
            throw new IllegalStateException("Both start and end time must be set");
        }
        if (this.start > this.end) {
            throw new IllegalStateException("Range start must not be later than range end");
        }
        if (this.name == null) {
            throw new IllegalStateException("Metric name must be set");
        }
        return new Query(this.name, this.asTags(), this.start, this.end);
    }

    public ImdgQueryBuilder reset() {
        this.name = null;
        this.start = Long.MIN_VALUE;
        this.end = Long.MIN_VALUE;
        this.resetTags();
        return this;
    }
}

