/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.imdg.ImdgMetricAwareBuilder;
import com.hazelcast.webmonitor.metrics.impl.utils.MetricsUtil;
import java.util.function.BiConsumer;

public class ImdgMetricDataPointBuilder
extends ImdgMetricAwareBuilder<ImdgMetricDataPointBuilder, MetricDataPoint> {
    public static final String IMDG_METRIC_UNIT_TAG = "metric-unit";
    private static final long MISSING_TIME = Long.MIN_VALUE;
    private static final String IMDG_CLIENT_TAG = "client";
    private static final String IMDG_CLIENT_TIMESTAMP_TAG = "timestamp";
    private final BiConsumer<String, String> descriptorTagsReader = (arg_0, arg_1) -> this.addTag(arg_0, arg_1);
    private long time = Long.MIN_VALUE;
    private DataPointType type;
    private long longValue = Long.MIN_VALUE;
    private double doubleValue = -9.223372036854776E18;
    private boolean ownerTagSet;
    private String unit;

    protected ImdgMetricDataPointBuilder self() {
        return this;
    }

    public ImdgMetricDataPointBuilder member(String address) {
        if (this.ownerTagSet) {
            return this;
        }
        this.ownerTagSet = true;
        return (ImdgMetricDataPointBuilder)super.member(address);
    }

    public ImdgMetricDataPointBuilder client(String uuid) {
        if (this.ownerTagSet) {
            return this;
        }
        this.ownerTagSet = true;
        return (ImdgMetricDataPointBuilder)super.client(uuid);
    }

    public ImdgMetricDataPointBuilder time(long time) {
        this.time = time;
        return this;
    }

    public ImdgMetricDataPointBuilder value(long value) {
        this.longValue = value;
        this.type = DataPointType.LONG;
        return this;
    }

    public ImdgMetricDataPointBuilder value(double value) {
        this.doubleValue = value;
        this.type = DataPointType.DOUBLE;
        return this;
    }

    public ImdgMetricDataPointBuilder metricDescriptor(MetricDescriptor descriptor) {
        this.name = MetricsUtil.metricName((MetricDescriptor)descriptor);
        if (descriptor.discriminator() != null) {
            this.addTag(descriptor.discriminator(), descriptor.discriminatorValue());
        }
        descriptor.readTags(this.descriptorTagsReader);
        if (this.unit == null) {
            this.unit = descriptor.unit() != null ? descriptor.unit().toString() : null;
        }
        return this;
    }

    public ImdgMetricDataPointBuilder unit(String unit) {
        this.unit = unit;
        return this;
    }

    public MetricDataPoint build() {
        if (this.time == Long.MIN_VALUE || this.type == null) {
            throw new IllegalStateException("Both time and value must be set");
        }
        if (this.name == null) {
            throw new IllegalStateException("Metric name must be set");
        }
        if (this.type == DataPointType.LONG) {
            return new MetricDataPoint(this.name, this.asTags(), this.time, this.longValue, this.unit);
        }
        return new MetricDataPoint(this.name, this.asTags(), this.time, this.doubleValue, this.unit);
    }

    public ImdgMetricDataPointBuilder reset() {
        this.ownerTagSet = false;
        this.name = null;
        this.time = Long.MIN_VALUE;
        this.type = null;
        this.longValue = Long.MIN_VALUE;
        this.doubleValue = -9.223372036854776E18;
        this.unit = null;
        this.resetTags();
        return this;
    }

    public ImdgMetricDataPointBuilder addTag(String name, String value) {
        if (this.interceptAddTag(name, value)) {
            return this.self();
        }
        return (ImdgMetricDataPointBuilder)super.addTag(name, value);
    }

    private boolean interceptAddTag(String tagName, String tagValue) {
        if (IMDG_CLIENT_TIMESTAMP_TAG.equals(tagName)) {
            try {
                this.time = Long.parseLong(tagValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        if (IMDG_CLIENT_TAG.equals(tagName)) {
            this.client(tagValue);
            return true;
        }
        if (IMDG_METRIC_UNIT_TAG.equals(tagName)) {
            this.unit(tagValue);
            return true;
        }
        return false;
    }
}

