/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.MetricAware;
import com.hazelcast.webmonitor.metrics.Tags;
import java.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ImdgMetricAwareBuilder<T extends ImdgMetricAwareBuilder<T, V>, V extends MetricAware> {
    public static final String MC_CLIENT_TAG = "mc:client";
    public static final String MC_CLUSTER_TAG = "mc:cluster";
    public static final String MC_MEMBER_TAG = "mc:member";
    private static final int INITIAL_TAG_CAPACITY = 5;
    private static final double GROW_FACTOR = 1.5;
    protected String name;
    private String[] tagNames = new String[5];
    private String[] tagValues = new String[5];
    private int tagPtr;

    protected ImdgMetricAwareBuilder() {
    }

    protected abstract T self();

    public abstract V build();

    public abstract T reset();

    public final T metric(String metric) {
        this.name = metric;
        return (T)this.self();
    }

    public final T cluster(String name) {
        this.addOrUpdateTag("mc:cluster", name);
        return (T)this.self();
    }

    public T member(String address) {
        this.addOrUpdateTag("mc:member", address);
        return (T)this.self();
    }

    public T client(String uuid) {
        this.addOrUpdateTag("mc:client", uuid);
        return (T)this.self();
    }

    public T addTag(String name, String value) {
        this.ensureCapacity(this.tagPtr);
        this.tagNames[this.tagPtr] = name;
        this.tagValues[this.tagPtr] = value;
        ++this.tagPtr;
        return (T)this.self();
    }

    private void addOrUpdateTag(String name, String value) {
        for (int i = 0; i < this.tagPtr; ++i) {
            String tagName = this.tagNames[i];
            if (tagName == null || !tagName.equals(name)) continue;
            this.tagValues[i] = value;
            return;
        }
        this.addTag(name, value);
    }

    protected final Tags asTags() {
        return new Tags(ImdgMetricAwareBuilder.copyTags((String[])this.tagNames, (int)this.tagPtr), ImdgMetricAwareBuilder.copyTags((String[])this.tagValues, (int)this.tagPtr));
    }

    protected final void resetTags() {
        this.tagPtr = 0;
        Arrays.fill(this.tagNames, null);
        Arrays.fill(this.tagValues, null);
    }

    private void ensureCapacity(int tagPtr) {
        if (tagPtr < this.tagNames.length) {
            return;
        }
        int newCapacity = (int)Math.max((double)tagPtr, Math.ceil((double)this.tagNames.length * 1.5));
        if (newCapacity % 2 != 0) {
            ++newCapacity;
        }
        this.tagNames = ImdgMetricAwareBuilder.copyTags((String[])this.tagNames, (int)newCapacity);
        this.tagValues = ImdgMetricAwareBuilder.copyTags((String[])this.tagValues, (int)newCapacity);
    }

    private static String[] copyTags(String[] tags, int newCapacity) {
        String[] newTags = new String[newCapacity];
        int len = Math.min(tags.length, newCapacity);
        System.arraycopy(tags, 0, newTags, 0, len);
        return newTags;
    }
}

