/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.AddWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.MapWithWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanPublisherStatsDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanReplicationDTO;
import com.hazelcast.webmonitor.controller.exception.NoMasterMemberApiException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.service.AddWanConfigResultDTO;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.WanReplicationManager;
import com.hazelcast.webmonitor.service.wan.WanReplicationConfigService;
import com.hazelcast.webmonitor.service.wan.WanReplicationStatsService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class WANController
extends BaseInternalController {
    private final WanReplicationManager wanReplicationManager;
    private final WanReplicationStatsService wanStatsService;
    private final WanReplicationConfigService wanReplicationConfigService;

    @Autowired
    public WANController(StateManager stateManager, WanReplicationManager wanReplicationManager, WanReplicationStatsService wanStatsService, WanReplicationConfigService wanReplicationConfigService, AuditLogService auditService) {
        super(stateManager, auditService);
        this.wanReplicationManager = wanReplicationManager;
        this.wanStatsService = wanStatsService;
        this.wanReplicationConfigService = wanReplicationConfigService;
    }

    @GetMapping(path={"/clusters/{cluster}/wanReplications"})
    public List<WanReplicationDTO> getWanReplications(@PathVariable String cluster, @RequestParam(required=false) String replication, @RequestParam(required=false) String publisher) {
        if (replication == null ^ publisher == null) {
            throw new ValidationFailedApiException("Replication and publisher must be specified together.");
        }
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        List wanReplications = this.wanStatsService.getWanReplications(state, cluster);
        if (replication != null) {
            WanPublisherStatsDTO publisherStats = this.wanStatsService.getWanPublisherStats(state, cluster, replication, publisher);
            this.enrichTargetPublisher(wanReplications, replication, publisherStats);
        }
        return wanReplications;
    }

    @GetMapping(path={"/clusters/{cluster}/wanReplications/{replication}/publishers/{publisher}"})
    public WanPublisherStatsDTO getPublisher(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return null;
        }
        return this.wanStatsService.getWanPublisherStats(state, cluster, replication, publisher);
    }

    @GetMapping(path={"/clusters/{cluster}/wanReplications/{replication}/maps"})
    public List<MapWithWanReplicationDTO> getMaps(@PathVariable String cluster, @PathVariable String replication) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        TimedMemberState masterState = (TimedMemberState)state.getMasterState().orElseThrow(() -> new NoMasterMemberApiException(cluster));
        MemberState memberState = masterState.getMemberState();
        MemberIdentifier masterIdentifier = MemberIdentifier.of((String)masterState.getClusterName(), (String)memberState.getAddress());
        return this.wanReplicationConfigService.getWanReplicatedMaps(replication, masterIdentifier, (Collection)memberState.getMaps());
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public AddWanConfigResultDTO addWanReplication(@PathVariable String cluster, @Valid @RequestBody AddWanReplicationDTO wanReplication, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        return (AddWanConfigResultDTO)this.executeOperation(() -> {
            AddWanConfigResult result = this.wanReplicationManager.addConfig(cluster, wanReplication);
            return new AddWanConfigResultDTO(result.getAddedPublisherIds(), result.getIgnoredPublisherIds());
        }, this.operationLogBuilder("MC-7001 [WAN]", "Add WAN Configuration").parameter("cluster", (Object)cluster).parameter("wanReplication", (Object)wanReplication.getName()));
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/checkConsistency"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void wanConsistencyCheck(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam String syncMap) {
        this.executeOperation(() -> this.wanReplicationManager.checkConsistency(cluster, wanReplication, publisher, syncMap), this.operationLogBuilder("MC-7002 [WAN]", "Run WAN Consistency Check").parameter("cluster", (Object)cluster).parameter("wanReplication", (Object)wanReplication).parameter("publisher", (Object)publisher).parameter("map", (Object)syncMap));
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/sync"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void wanSyncMap(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam(required=false) String syncMap) {
        Runnable operation = syncMap != null ? () -> this.wanReplicationManager.syncMap(cluster, wanReplication, publisher, syncMap) : () -> this.wanReplicationManager.syncAllMaps(cluster, wanReplication, publisher);
        this.executeOperation(operation, this.operationLogBuilder("MC-7003 [WAN]", "Run WAN Sync Map").parameter("cluster", (Object)cluster).parameter("wanReplication", (Object)wanReplication).parameter("publisher", (Object)publisher).parameter("map", (Object)syncMap).parameter("allMaps", (Object)(syncMap == null ? 1 : 0)));
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/changeState"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void changeWanState(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam WanPublisherState state, @RequestParam(required=false) String member) {
        Runnable operation = member == null ? () -> this.wanReplicationManager.changeState(cluster, wanReplication, publisher, state) : () -> this.wanReplicationManager.changeState(cluster, wanReplication, publisher, member, state);
        this.executeOperation(operation, this.operationLogBuilder("MC-7004 [WAN]", "Change WAN Publisher State").parameter("cluster", (Object)cluster).parameter("wanReplication", (Object)wanReplication).parameter("publisher", (Object)publisher).parameter("state", (Object)state).parameter("member", (Object)member).parameter("allMembers", (Object)(member == null ? 1 : 0)));
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/clearQueues"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void clearQueues(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam String member) {
        this.executeOperation(() -> this.wanReplicationManager.clearQueues(cluster, wanReplication, publisher, member), this.operationLogBuilder("MC-7005 [WAN]", "Clear WAN Queues").parameter("cluster", (Object)cluster).parameter("wanReplication", (Object)wanReplication).parameter("publisher", (Object)publisher));
    }

    private void enrichTargetPublisher(List<WanReplicationDTO> wanReplications, String replication, WanPublisherStatsDTO fullPublisherStats) {
        for (WanReplicationDTO wanReplicationDTO : wanReplications) {
            if (!replication.equals(wanReplicationDTO.getName())) continue;
            wanReplicationDTO.getDestinations().replaceAll(oldPublisher -> Objects.equals(fullPublisherStats.getName(), oldPublisher.getName()) ? fullPublisherStats : oldPublisher);
            break;
        }
    }
}

