/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.external;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringConfigDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListWithEntriesDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringSummaryDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringTestDeployDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringValidationRequestDTO;
import com.hazelcast.webmonitor.controller.exception.NoClientApiException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListWithEntries;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import com.hazelcast.webmonitor.service.ClusterHealthCheckService;
import com.hazelcast.webmonitor.service.EnterpriseServiceProvider;
import com.hazelcast.webmonitor.service.Licensed;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringService;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest"})
@ConditionalOnProperty(name={"hazelcast.mc.rest.enabled"}, havingValue="true")
public class ClientRestController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientRestController.class);
    private static final Feature FEATURE = Feature.CLUSTERED_REST;
    private final EnterpriseServiceProvider enterpriseServiceProvider;
    private final ClientFilteringService clientFilteringService;
    private final ClusterHealthCheckService clusterHealthCheckService;
    private final Notifier notifier;

    @GetMapping(path={"/clusters/{cluster}/clients"})
    @Licensed(value={Feature.CLUSTERED_REST})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public Collection<ClientEndPointDTO> clients(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getClients().values();
    }

    @GetMapping(path={"/clusters/{cluster}/clients/{clientUuid}"})
    @Licensed(value={Feature.CLUSTERED_REST})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public ClientEndPointDTO client(@PathVariable String cluster, @PathVariable String clientUuid) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        ClientEndPointDTO clientEndPointDTO = (ClientEndPointDTO)latestState.getClientsPerUuid().get(clientUuid);
        if (clientEndPointDTO == null) {
            throw NoClientApiException.forUuid((String)clientUuid);
        }
        return clientEndPointDTO;
    }

    @GetMapping(path={"/clusters/{cluster}/clientendpoints"})
    @Licensed(value={Feature.CLUSTERED_REST})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public Set<String> clientEndpoints(@PathVariable String cluster) {
        return this.enterpriseServiceProvider.getLatestState(cluster, FEATURE).getClientAddresses();
    }

    @GetMapping(path={"/clusters/{cluster}/clientendpoints/{clientAddress}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public ClientEndPointDTO clientByAddress(@PathVariable String cluster, @PathVariable String clientAddress) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        ClientEndPointDTO clientEndPointDTO = (ClientEndPointDTO)latestState.getClients().get(clientAddress);
        if (clientEndPointDTO == null) {
            throw NoClientApiException.forAddress((String)clientAddress);
        }
        return clientEndPointDTO;
    }

    @GetMapping(path={"/clusters/{cluster}/clientfiltering/lists"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public List<ClientFilteringListWithEntriesDTO> getClientFilteringLists(@PathVariable String cluster) {
        List all = this.clientFilteringService.getAll(cluster);
        return all.stream().map(ClientFilteringListWithEntriesDTO::fromModel).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/clientfiltering/lists/{listId}"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public ClientFilteringListWithEntriesDTO getClientFilteringList(@PathVariable String cluster, @PathVariable Long listId) {
        ClientFilteringListWithEntries listWithEntries = this.clientFilteringService.get(listId);
        return ClientFilteringListWithEntriesDTO.fromModel((ClientFilteringListWithEntries)listWithEntries);
    }

    @PostMapping(path={"/clusters/{cluster}/clientfiltering/lists"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public ClientFilteringListWithEntriesDTO createClientFilteringList(@PathVariable String cluster, @Valid @RequestBody ClientFilteringListWithEntriesDTO list, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        ClientFilteringListWithEntries created = this.clientFilteringService.create(cluster, list.toModel());
        this.notifyClientFilteringUpdate(cluster);
        return ClientFilteringListWithEntriesDTO.fromModel((ClientFilteringListWithEntries)created);
    }

    @PostMapping(path={"/clusters/{cluster}/clientfiltering/lists/{listId}"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public ClientFilteringListWithEntriesDTO updateClientFilteringList(@PathVariable String cluster, @PathVariable Long listId, @Valid @RequestBody ClientFilteringListWithEntriesDTO list, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clientFilteringService.update(cluster, list.toModel());
        this.notifyClientFilteringUpdate(cluster);
        return ClientFilteringListWithEntriesDTO.fromModel((ClientFilteringListWithEntries)this.clientFilteringService.get(listId));
    }

    @DeleteMapping(path={"/clusters/{cluster}/clientfiltering/lists/{listId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void deleteClientFilteringList(@PathVariable String cluster, @PathVariable Long listId) {
        this.clientFilteringService.delete(cluster, listId);
        this.notifyClientFilteringUpdate(cluster);
    }

    @PostMapping(path={"/clusters/{cluster}/clientfiltering/deploy"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void deploy(@PathVariable String cluster, @Valid @RequestBody ClientFilteringConfigDTO deployConfig, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clientFilteringService.deploy(cluster, deployConfig.getStatus(), deployConfig.getType());
        this.notifyClientFilteringUpdate(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/clientfiltering"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public ClientFilteringSummaryDTO getSummary(@PathVariable String cluster) {
        ClusterClientFilteringDTO fullConfig = this.clientFilteringService.getFullClientFilteringConfigForCluster(cluster);
        int connectedClients = Optional.ofNullable(this.clusterHealthCheckService.check(cluster).getNumberOfConnectedClients()).orElse(0);
        return ClientFilteringSummaryDTO.builder().status(fullConfig.getStatus()).type(fullConfig.getType()).numberOfConnectedClients(connectedClients).activeRules(ClientFilteringUtil.groupByTypeAndSortEntries((List)fullConfig.getActiveEntries())).etag(fullConfig.getEtag()).build();
    }

    @PostMapping(path={"/clusters/{cluster}/clientfiltering/validate"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public List<String> validate(@PathVariable String cluster, @Valid @RequestBody ClientFilteringValidationRequestDTO validationRequest, BindingResult bindingResult) {
        return bindingResult.getFieldErrors().stream().map(fieldError -> fieldError.getField() + ": " + fieldError.getDefaultMessage()).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/clientfiltering/testdeploy"})
    @Licensed(value={Feature.CLUSTERED_REST, Feature.CLIENT_FILTERING})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public ClientFilteringTestDeployDTO testDeploy(@PathVariable String cluster, @RequestParam ClientFilteringListType type) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        Collection clients = latestState.getClientsPerUuid().values();
        List entries = this.clientFilteringService.getActiveEntries(cluster, type);
        return ClientFilteringUtil.testDeploy((ClientFilteringListType)type, (List)entries, clients);
    }

    private void notifyClientFilteringUpdate(String cluster) {
        String newEtag = this.clientFilteringService.getDeployedForMembers(cluster).getETag();
        this.notifier.signal(Note.Matter.CLIENT_FILTERS_UPDATED_VIA_API.on(cluster, " ETag " + newEtag));
    }

    @ConstructorProperties(value={"enterpriseServiceProvider", "clientFilteringService", "clusterHealthCheckService", "notifier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientRestController(EnterpriseServiceProvider enterpriseServiceProvider, ClientFilteringService clientFilteringService, ClusterHealthCheckService clusterHealthCheckService, Notifier notifier) {
        this.enterpriseServiceProvider = enterpriseServiceProvider;
        this.clientFilteringService = clientFilteringService;
        this.clusterHealthCheckService = clusterHealthCheckService;
        this.notifier = notifier;
    }
}

