/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListEntryDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListEntryModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListStatus;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListWithEntries;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;

public class ClientFilteringListWithEntriesDTO
extends ClientFilteringListDTO
implements IdentifiedDataSerializable {
    @Valid
    private List<ClientFilteringListEntryDTO> entries;

    public ClientFilteringListWithEntriesDTO(ClientFilteringListDTO baseDto) {
        this.setId(baseDto.getId());
        this.setName(baseDto.getName());
        this.setStatus(baseDto.getStatus());
        this.setType(baseDto.getType());
    }

    public ClientFilteringListWithEntries toModel() {
        ClientFilteringListWithEntries model = new ClientFilteringListWithEntries();
        model.setId(this.getId());
        model.setName(this.getName());
        model.setStatus(this.getStatus());
        model.setType(this.getType());
        if (this.entries != null) {
            List entryModels = this.entries.stream().map(ClientFilteringListEntryDTO::toModel).collect(Collectors.toList());
            model.setEntries(entryModels);
        }
        return model;
    }

    public static ClientFilteringListWithEntriesDTO fromModel(ClientFilteringListWithEntries model) {
        ClientFilteringListDTO baseDto = ClientFilteringListDTO.fromModel((ClientFilteringListModel)model);
        ClientFilteringListWithEntriesDTO dto = new ClientFilteringListWithEntriesDTO(baseDto);
        ArrayList<ClientFilteringListEntryDTO> entries = new ArrayList<ClientFilteringListEntryDTO>();
        if (model.getEntries() != null) {
            for (ClientFilteringListEntryModel entryModel : model.getEntries()) {
                entries.add(ClientFilteringListEntryDTO.fromModel((ClientFilteringListEntryModel)entryModel));
            }
        }
        dto.setEntries(entries);
        return dto;
    }

    public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
        objectDataOutput.writeObject((Object)this.getId());
        objectDataOutput.writeString(this.getName());
        objectDataOutput.writeObject((Object)this.getStatus());
        objectDataOutput.writeObject((Object)this.getType());
        objectDataOutput.writeObject((Object)this.entries);
    }

    public void readData(ObjectDataInput objectDataInput) throws IOException {
        this.setId((Long)objectDataInput.readObject());
        this.setName(objectDataInput.readString());
        this.setStatus((ClientFilteringListStatus)objectDataInput.readObject());
        this.setType((ClientFilteringListType)objectDataInput.readObject());
        this.entries = (List)objectDataInput.readObject();
    }

    @JsonIgnore
    public int getFactoryId() {
        return 1;
    }

    @JsonIgnore
    public int getClassId() {
        return 2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ClientFilteringListEntryDTO> getEntries() {
        return this.entries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEntries(List<ClientFilteringListEntryDTO> entries) {
        this.entries = entries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ClientFilteringListWithEntriesDTO(entries=" + this.getEntries() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFilteringListWithEntriesDTO() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientFilteringListWithEntriesDTO)) {
            return false;
        }
        ClientFilteringListWithEntriesDTO other = (ClientFilteringListWithEntriesDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List this$entries = this.getEntries();
        List other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientFilteringListWithEntriesDTO;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }
}

