/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.metrics.impl.EmbeddedMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.MetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.PersistentStore;
import com.hazelcast.webmonitor.metrics.impl.noop.InMemoryMetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.noop.NoOpPersistentStore;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBStore;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageDiagnosticsSupplier;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageStatsCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class MetricsStorageConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsStorageConfig.class);
    public static final String METRICS_SUBDIR = "metrics";
    public static final int MAX_IN_MEMORY_METRICS_REGISTRY_CACHE_SIZE = 300000;
    private static final String[] ROCKSDB_UNSUPPORTED_OS_LIST = new String[]{"z/os"};
    private final MetricsConfigurationProperties metricsProperties;
    boolean inMemoryMetricsMode;

    public MetricsStorageConfig(MCConfigurationProperties mcProperties, MetricsConfigurationProperties metricsProperties) {
        boolean cloud = mcProperties.getInternal().isCloud();
        this.metricsProperties = metricsProperties;
        String osName = System.getProperty("os.name");
        boolean rocksDBUnsupportedOS = StringUtils.containsAnyIgnoreCase((CharSequence)osName, (CharSequence[])ROCKSDB_UNSUPPORTED_OS_LIST);
        boolean bl = this.inMemoryMetricsMode = cloud || !metricsProperties.isPersistenceEnabled() || rocksDBUnsupportedOS;
        if (rocksDBUnsupportedOS) {
            log.warn("Metrics persistence is disabled because OS {} is not supported by RocksDB", (Object)osName);
        }
    }

    public boolean isInMemoryMetricsMode() {
        return this.inMemoryMetricsMode;
    }

    public static Path createMetricsDir(HomeDirectoryProvider homeDirectoryProvider) {
        Path dir = homeDirectoryProvider.get().resolve("metrics");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create directory " + dir + " for metrics storage", e);
        }
        return dir;
    }

    @Bean
    public EmbeddedMetricsStorage metricsStorage(MetricsStorageStatsCounter statsCounter, MetricsRegistry metricsRegistry, PersistentStore store, Clock clock, MetricsConfigurationProperties metricsProperties) {
        return new EmbeddedMetricsStorage(statsCounter, clock, metricsRegistry, store, 10000, metricsProperties.getAccumulationPeriod());
    }

    @Bean
    public MetricsRegistry metricsRegistry(HomeDirectoryProvider homeDirectoryProvider) {
        if (this.inMemoryMetricsMode) {
            return new InMemoryMetricsRegistry(300000);
        }
        try {
            Path dir = MetricsStorageConfig.createMetricsDir((HomeDirectoryProvider)homeDirectoryProvider);
            return new RocksDBMetricsRegistry(dir, 300000);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize metrics registry", e);
        }
    }

    @Bean
    public PersistentStore persistentStore(HomeDirectoryProvider homeDirectoryProvider, MetricsStorageStatsCounter statsCounter, MetricsConfigurationProperties metricsProperties) {
        if (this.inMemoryMetricsMode) {
            return new NoOpPersistentStore();
        }
        try {
            Path dir = MetricsStorageConfig.createMetricsDir((HomeDirectoryProvider)homeDirectoryProvider);
            Duration persistentStoreTtl = metricsProperties.getDiskTtl();
            return new RocksDBStore(dir, persistentStoreTtl, statsCounter.getDataPointMemoryCompressionTracker());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize metrics store", e);
        }
    }

    @Bean
    public MetricsStorageDiagnosticsSupplier metricsStorageDiagnosticsSupplier(EmbeddedMetricsStorage metricsStorage, HomeDirectoryProvider homeDirectoryProvider, MetricsStorageStatsCounter statsCounter) {
        return new MetricsStorageDiagnosticsSupplier(metricsStorage, homeDirectoryProvider, statsCounter, this.inMemoryMetricsMode, this.metricsProperties.getDiskTtl());
    }
}

