/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.service.SettingsService;
import java.io.PrintWriter;
import java.util.List;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Displays configured MC settings"})
class ReadSettingsTask
extends BaseCliTask {
    ReadSettingsTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        SettingsService settingsService = new SettingsService(new SettingsDAO(this.initJdbi()));
        List maskedConfigProperties = settingsService.getMaskedConfigProperties();
        List hiddenProperties = settingsService.getHiddenProperties();
        this.println("Configured settings:");
        if (!maskedConfigProperties.isEmpty()) {
            this.println("MASKED_CONFIG_PROPERTIES=" + String.join((CharSequence)",", maskedConfigProperties));
        }
        if (!hiddenProperties.isEmpty()) {
            this.println("HIDDEN_PROPERTIES=" + String.join((CharSequence)",", hiddenProperties));
        }
    }
}

