/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.GroupsToRolesMappingOptions;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.PersistentSamlConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlConfig;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configure SAML Security Provider. No Security Provider should be already configured when using this task. If you need to overwrite security provider configuration, use 'security reset' task first.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false, showDefaultValues=true)
public class ConfigureSamlTask
extends BaseCliTask {
    @CommandLine.Option(names={"-rpi", "--relying-party-id"}, required=true, description={"SAML Relying Party Identifier."})
    private String relyingPartyId;
    @CommandLine.Option(names={"-pbu", "--post-back-url"}, required=true, description={"SAML Post Back URL."})
    private String postBackUrl;
    @CommandLine.Option(names={"-ga", "--group-attribute"}, required=true, description={"SAML Group Attribute."})
    private String groupAttribute;
    @CommandLine.Option(names={"-idpm", "--idp-metadata"}, required=true, description={"SAML Identity Provider Metadata."})
    private String idpMetadata;
    @CommandLine.Option(names={"-gns", "--group-name-separator"}, defaultValue=",", description={"SAML Group Name Separator."})
    private String groupNameSeparator;
    @CommandLine.Mixin
    private GroupsToRolesMappingOptions groupsToRolesMappingOptions;

    ConfigureSamlTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        if (securityManager.getCurrentSecurityProviderName() != null) {
            throw new CliException("Security Provider is already configured. Use 'security reset' task first, if you want to set up new security provider.");
        }
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        PersistentSamlConfig persistentConfig = new PersistentSamlConfig(groupedSettingsDAO);
        persistentConfig.write((SecurityProviderConfig)this.samlConfig());
        securityManager.setCurrentSecurityProviderName("SAML");
        this.println("Successfully set up SAML security provider.");
    }

    private SamlConfig samlConfig() {
        return SamlConfig.builder().relyingPartyId(this.relyingPartyId).postBackUrl(this.postBackUrl).groupAttribute(this.groupAttribute).idpMetadata(this.idpMetadata).groupNameSeparator(this.groupNameSeparator).groupsToRolesMappingConfig(this.groupsToRolesMappingOptions.toConfig()).build();
    }
}

