/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.repositories.sql.ScriptDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserCredentialsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.builtin.PasswordStrengthChecker;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.PrintWriter;
import java.nio.file.Path;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;

abstract class BaseUserTask
extends BaseCliTask {
    BaseUserTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    DefaultSecurityProvider initDefaultSecurityProvider(boolean setProviderIfNone) {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        UserDAO userDAO = new UserDAO(jdbi);
        UserCredentialsDAO userCredentialsDAO = new UserCredentialsDAO(jdbi);
        ScriptDAO scriptDAO = new ScriptDAO(jdbi);
        AuthTokenDAO authTokenDAO = new AuthTokenDAO(jdbi);
        JdbiHistories histories = new JdbiHistories(jdbi);
        PasswordStrengthChecker passwordStrengthChecker = new PasswordStrengthChecker((Path)this.environment.getProperty("hazelcast.mc.security.dictionary.path", Path.class), ((Integer)this.environment.getProperty("hazelcast.mc.security.dictionary.minWordLength", Integer.class, (Object)3)).intValue());
        DefaultSecurityProvider defaultSecurityProvider = new DefaultSecurityProvider(jdbi, userDAO, userCredentialsDAO, scriptDAO, authTokenDAO, histories, passwordStrengthChecker);
        if (setProviderIfNone && StringUtil.isNullOrEmptyAfterTrim((String)securityManager.getCurrentSecurityProviderName())) {
            this.println("No security provider is configured in Management Center. Setting security provider to the default one.");
            securityManager.setCurrentSecurityProviderName(defaultSecurityProvider.getName());
        }
        if (securityManager.getCurrentSecurityProviderName() == null) {
            throw new CliException("Security provider is not configured in Management Center.");
        }
        if (!defaultSecurityProvider.getName().equals(securityManager.getCurrentSecurityProviderName())) {
            throw new CliException("Only default security provider is supported by this task.");
        }
        return defaultSecurityProvider;
    }
}

