/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.rewrite;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.InternalColumnEncryptionSetup;
import org.apache.parquet.crypto.InternalFileEncryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.rewrite.MaskMode;
import org.apache.parquet.hadoop.rewrite.RewriteOptions;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopCodecs;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRewriter
implements Closeable {
    public static final String ORIGINAL_CREATED_BY_KEY = "original.created.by";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetRewriter.class);
    private final int pageBufferSize = 0x200000;
    private final byte[] pageBuffer = new byte[0x200000];
    private CompressionCodecName newCodecName = null;
    private List<String> pruneColumns = null;
    private Map<ColumnPath, MaskMode> maskColumns = null;
    private Set<ColumnPath> encryptColumns = null;
    private boolean encryptMode = false;
    private Map<String, String> extraMetaData = new HashMap<String, String>();
    private ParquetFileWriter writer;
    private int numBlocksRewritten = 0;
    private Queue<CompressionConverter.TransParquetFileReader> inputFiles = new LinkedList<CompressionConverter.TransParquetFileReader>();
    private MessageType schema = null;
    private CompressionConverter.TransParquetFileReader reader = null;
    private ParquetMetadata meta = null;
    private String originalCreatedBy = "";
    private Set<String> allOriginalCreatedBys = new HashSet<String>();

    public ParquetRewriter(RewriteOptions options) throws IOException {
        Configuration conf = options.getConf();
        Path outPath = options.getOutputFile();
        this.openInputFiles(options.getInputFiles(), conf);
        LOG.info("Start rewriting {} input files {} to {}", (Object)this.inputFiles.size(), (Object)outPath);
        this.initNextReader();
        this.newCodecName = options.getNewCodecName();
        this.pruneColumns = options.getPruneColumns();
        if (this.pruneColumns != null && !this.pruneColumns.isEmpty()) {
            ArrayList<String> paths = new ArrayList<String>();
            this.getPaths(this.schema, paths, null);
            for (String col : this.pruneColumns) {
                if (paths.contains(col)) continue;
                LOG.warn("Input column name {} doesn't show up in the schema of file {}", (Object)col, (Object)this.reader.getFile());
            }
            Set<ColumnPath> set = this.convertToColumnPaths(this.pruneColumns);
            this.schema = this.pruneColumnsInSchema(this.schema, set);
        }
        if (options.getMaskColumns() != null) {
            this.maskColumns = new HashMap<ColumnPath, MaskMode>();
            for (Map.Entry entry : options.getMaskColumns().entrySet()) {
                this.maskColumns.put(ColumnPath.fromDotString((String)entry.getKey()), (MaskMode)((Object)entry.getValue()));
            }
        }
        if (options.getEncryptColumns() != null && options.getFileEncryptionProperties() != null) {
            this.encryptColumns = this.convertToColumnPaths(options.getEncryptColumns());
            this.encryptMode = true;
        }
        ParquetFileWriter.Mode writerMode = ParquetFileWriter.Mode.CREATE;
        this.writer = new ParquetFileWriter((OutputFile)HadoopOutputFile.fromPath(outPath, conf), this.schema, writerMode, 0x8000000L, 0x800000, 64, Integer.MAX_VALUE, true, options.getFileEncryptionProperties());
        this.writer.start();
    }

    public ParquetRewriter(CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, ParquetMetadata meta, MessageType schema, String originalCreatedBy, CompressionCodecName codecName, List<String> maskColumns, MaskMode maskMode) {
        this.reader = reader;
        this.writer = writer;
        this.meta = meta;
        this.schema = schema;
        this.newCodecName = codecName;
        originalCreatedBy = originalCreatedBy == null ? meta.getFileMetaData().getCreatedBy() : originalCreatedBy;
        this.extraMetaData.putAll(meta.getFileMetaData().getKeyValueMetaData());
        this.extraMetaData.put(ORIGINAL_CREATED_BY_KEY, originalCreatedBy);
        if (maskColumns != null && maskMode != null) {
            this.maskColumns = new HashMap<ColumnPath, MaskMode>();
            for (String col : maskColumns) {
                this.maskColumns.put(ColumnPath.fromDotString(col), maskMode);
            }
        }
    }

    private void openInputFiles(List<Path> inputFiles, Configuration conf) {
        Preconditions.checkArgument(inputFiles != null && !inputFiles.isEmpty(), "No input files");
        for (Path inputFile : inputFiles) {
            try {
                CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader(HadoopInputFile.fromPath(inputFile, conf), HadoopReadOptions.builder(conf).build());
                MessageType inputFileSchema = reader.getFooter().getFileMetaData().getSchema();
                if (this.schema == null) {
                    this.schema = inputFileSchema;
                } else if (!this.schema.equals((Object)inputFileSchema)) {
                    LOG.error("Input files have different schemas, expect: {}, input: {}, current file: {}", this.schema, inputFileSchema, inputFile);
                    throw new InvalidSchemaException("Input files have different schemas, current file: " + inputFile);
                }
                this.allOriginalCreatedBys.add(reader.getFooter().getFileMetaData().getCreatedBy());
                this.inputFiles.add(reader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to open input file: " + inputFile, e);
            }
        }
        this.extraMetaData.put(ORIGINAL_CREATED_BY_KEY, String.join((CharSequence)"\n", this.allOriginalCreatedBys));
    }

    private void initNextReader() {
        if (this.reader != null) {
            LOG.info("Finish rewriting input file: {}", (Object)this.reader.getFile());
        }
        if (this.inputFiles.isEmpty()) {
            this.reader = null;
            this.meta = null;
            this.originalCreatedBy = null;
            return;
        }
        this.reader = this.inputFiles.poll();
        this.meta = this.reader.getFooter();
        this.originalCreatedBy = this.meta.getFileMetaData().getCreatedBy();
        this.extraMetaData.putAll(this.meta.getFileMetaData().getKeyValueMetaData());
        LOG.info("Rewriting input file: {}, remaining files: {}", (Object)this.reader.getFile(), (Object)this.inputFiles.size());
    }

    @Override
    public void close() throws IOException {
        this.writer.end(this.extraMetaData);
    }

    public void processBlocks() throws IOException {
        while (this.reader != null) {
            this.processBlocksFromReader();
            this.initNextReader();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBlocksFromReader() throws IOException {
        PageReadStore store = this.reader.readNextRowGroup();
        ColumnReadStoreImpl crStore = new ColumnReadStoreImpl(store, new DummyGroupConverter(), this.schema, this.originalCreatedBy);
        Map<ColumnPath, ColumnDescriptor> descriptorsMap = this.schema.getColumns().stream().collect(Collectors.toMap(x -> ColumnPath.get(x.getPath()), x -> x));
        int blockId = 0;
        while (store != null) {
            this.writer.startBlock(store.getRowCount());
            BlockMetaData blockMetaData = this.meta.getBlocks().get(blockId);
            List<ColumnChunkMetaData> columnsInOrder = blockMetaData.getColumns();
            int columnId = 0;
            for (int i = 0; i < columnsInOrder.size(); ++i) {
                boolean encryptColumn;
                ColumnChunkMetaData chunk = columnsInOrder.get(i);
                ColumnDescriptor descriptor = descriptorsMap.get(chunk.getPath());
                if (descriptor == null) continue;
                if (chunk.isEncrypted()) {
                    throw new IOException("Column " + chunk.getPath().toDotString() + " is already encrypted");
                }
                this.reader.setStreamPosition(chunk.getStartingPos());
                CompressionCodecName newCodecName = this.newCodecName == null ? chunk.getCodec() : this.newCodecName;
                boolean bl = encryptColumn = this.encryptMode && this.encryptColumns != null && this.encryptColumns.contains(chunk.getPath());
                if (this.maskColumns != null && this.maskColumns.containsKey(chunk.getPath())) {
                    MaskMode maskMode = this.maskColumns.get(chunk.getPath());
                    if (!maskMode.equals((Object)MaskMode.NULLIFY)) throw new UnsupportedOperationException("Only nullify is supported for now");
                    Type.Repetition repetition = descriptor.getPrimitiveType().getRepetition();
                    if (repetition.equals((Object)Type.Repetition.REQUIRED)) {
                        throw new IOException("Required column [" + descriptor.getPrimitiveType().getName() + "] cannot be nullified");
                    }
                    this.nullifyColumn(descriptor, chunk, crStore, this.writer, this.schema, newCodecName, encryptColumn);
                } else if (this.encryptMode || this.newCodecName != null) {
                    ColumnChunkEncryptorRunTime columnChunkEncryptorRunTime = null;
                    if (this.encryptMode) {
                        columnChunkEncryptorRunTime = new ColumnChunkEncryptorRunTime(this.writer.getEncryptor(), chunk, this.numBlocksRewritten, columnId);
                    }
                    this.writer.startColumn(descriptor, crStore.getColumnReader(descriptor).getTotalValueCount(), newCodecName);
                    this.processChunk(chunk, newCodecName, columnChunkEncryptorRunTime, encryptColumn);
                    this.writer.endColumn();
                } else {
                    BloomFilter bloomFilter = this.reader.readBloomFilter(chunk);
                    ColumnIndex columnIndex = this.reader.readColumnIndex(chunk);
                    OffsetIndex offsetIndex = this.reader.readOffsetIndex(chunk);
                    this.writer.appendColumnChunk(descriptor, this.reader.getStream(), chunk, bloomFilter, columnIndex, offsetIndex);
                }
                ++columnId;
            }
            this.writer.endBlock();
            store = this.reader.readNextRowGroup();
            ++blockId;
            ++this.numBlocksRewritten;
        }
    }

    private void processChunk(ColumnChunkMetaData chunk, CompressionCodecName newCodecName, ColumnChunkEncryptorRunTime columnChunkEncryptorRunTime, boolean encryptColumn) throws IOException {
        CompressionCodecFactory codecFactory = HadoopCodecs.newFactory(0);
        CompressionCodecFactory.BytesInputDecompressor decompressor = null;
        CompressionCodecFactory.BytesInputCompressor compressor = null;
        if (!newCodecName.equals((Object)chunk.getCodec())) {
            decompressor = codecFactory.getDecompressor(chunk.getCodec());
            compressor = codecFactory.getCompressor(newCodecName);
        }
        BlockCipher.Encryptor metaEncryptor = null;
        BlockCipher.Encryptor dataEncryptor = null;
        byte[] dictPageAAD = null;
        byte[] dataPageAAD = null;
        byte[] dictPageHeaderAAD = null;
        byte[] dataPageHeaderAAD = null;
        if (columnChunkEncryptorRunTime != null) {
            metaEncryptor = columnChunkEncryptorRunTime.getMetaDataEncryptor();
            dataEncryptor = columnChunkEncryptorRunTime.getDataEncryptor();
            dictPageAAD = columnChunkEncryptorRunTime.getDictPageAAD();
            dataPageAAD = columnChunkEncryptorRunTime.getDataPageAAD();
            dictPageHeaderAAD = columnChunkEncryptorRunTime.getDictPageHeaderAAD();
            dataPageHeaderAAD = columnChunkEncryptorRunTime.getDataPageHeaderAAD();
        }
        ColumnIndex columnIndex = this.reader.readColumnIndex(chunk);
        OffsetIndex offsetIndex = this.reader.readOffsetIndex(chunk);
        this.reader.setStreamPosition(chunk.getStartingPos());
        Object dictionaryPage = null;
        long readValues = 0L;
        Statistics statistics = null;
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        int pageOrdinal = 0;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            PageHeader pageHeader = this.reader.readPageHeader();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new IOException("has more than one dictionary page in column chunk");
                    }
                    DictionaryPageHeader dictPageHeader = pageHeader.dictionary_page_header;
                    byte[] pageLoad = this.processPageLoad(this.reader, true, compressor, decompressor, pageHeader.getCompressed_page_size(), pageHeader.getUncompressed_page_size(), encryptColumn, dataEncryptor, dictPageAAD);
                    this.writer.writeDictionaryPage(new DictionaryPage(BytesInput.from(pageLoad), pageHeader.getUncompressed_page_size(), dictPageHeader.getNum_values(), converter.getEncoding(dictPageHeader.getEncoding())), metaEncryptor, dictPageHeaderAAD);
                    continue block5;
                }
                case DATA_PAGE: {
                    if (encryptColumn) {
                        AesCipher.quickUpdatePageAAD(dataPageHeaderAAD, pageOrdinal);
                        AesCipher.quickUpdatePageAAD(dataPageAAD, pageOrdinal);
                    }
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    byte[] pageLoad = this.processPageLoad(this.reader, true, compressor, decompressor, pageHeader.getCompressed_page_size(), pageHeader.getUncompressed_page_size(), encryptColumn, dataEncryptor, dataPageAAD);
                    statistics = this.convertStatistics(this.originalCreatedBy, chunk.getPrimitiveType(), headerV1.getStatistics(), columnIndex, pageOrdinal, converter);
                    readValues += (long)headerV1.getNum_values();
                    if (offsetIndex != null) {
                        long rowCount = 1L + offsetIndex.getLastRowIndex(pageOrdinal, totalChunkValues) - offsetIndex.getFirstRowIndex(pageOrdinal);
                        this.writer.writeDataPage(this.toIntWithCheck(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from(pageLoad), statistics, this.toIntWithCheck(rowCount), converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()), metaEncryptor, dataPageHeaderAAD);
                    } else {
                        this.writer.writeDataPage(this.toIntWithCheck(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from(pageLoad), statistics, converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()), metaEncryptor, dataPageHeaderAAD);
                    }
                    ++pageOrdinal;
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    if (encryptColumn) {
                        AesCipher.quickUpdatePageAAD(dataPageHeaderAAD, pageOrdinal);
                        AesCipher.quickUpdatePageAAD(dataPageAAD, pageOrdinal);
                    }
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    BytesInput rlLevels = this.readBlockAllocate(rlLength, this.reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    BytesInput dlLevels = this.readBlockAllocate(dlLength, this.reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    int rawDataLength = pageHeader.getUncompressed_page_size() - rlLength - dlLength;
                    byte[] pageLoad = this.processPageLoad(this.reader, headerV2.is_compressed, compressor, decompressor, payLoadLength, rawDataLength, encryptColumn, dataEncryptor, dataPageAAD);
                    statistics = this.convertStatistics(this.originalCreatedBy, chunk.getPrimitiveType(), headerV2.getStatistics(), columnIndex, pageOrdinal, converter);
                    readValues += (long)headerV2.getNum_values();
                    this.writer.writeDataPageV2(headerV2.getNum_rows(), headerV2.getNum_nulls(), headerV2.getNum_values(), rlLevels, dlLevels, converter.getEncoding(headerV2.getEncoding()), BytesInput.from(pageLoad), rawDataLength, statistics);
                    ++pageOrdinal;
                    continue block5;
                }
            }
            LOG.debug("skipping page of type {} of size {}", (Object)pageHeader.getType(), (Object)compressedPageSize);
        }
    }

    private Statistics convertStatistics(String createdBy, PrimitiveType type, org.apache.parquet.format.Statistics pageStatistics, ColumnIndex columnIndex, int pageIndex, ParquetMetadataConverter converter) throws IOException {
        if (columnIndex != null) {
            if (columnIndex.getNullPages() == null) {
                throw new IOException("columnIndex has null variable 'nullPages' which indicates corrupted data for type: " + type.getName());
            }
            if (pageIndex > columnIndex.getNullPages().size()) {
                throw new IOException("There are more pages " + pageIndex + " found in the column than in the columnIndex " + columnIndex.getNullPages().size());
            }
            Statistics.Builder statsBuilder = Statistics.getBuilderForReading(type);
            statsBuilder.withNumNulls(columnIndex.getNullCounts().get(pageIndex));
            if (!columnIndex.getNullPages().get(pageIndex).booleanValue()) {
                statsBuilder.withMin((byte[])columnIndex.getMinValues().get(pageIndex).array().clone());
                statsBuilder.withMax((byte[])columnIndex.getMaxValues().get(pageIndex).array().clone());
            }
            return statsBuilder.build();
        }
        if (pageStatistics != null) {
            return converter.fromParquetStatistics(createdBy, pageStatistics, type);
        }
        return null;
    }

    private byte[] processPageLoad(CompressionConverter.TransParquetFileReader reader, boolean isCompressed, CompressionCodecFactory.BytesInputCompressor compressor, CompressionCodecFactory.BytesInputDecompressor decompressor, int payloadLength, int rawDataLength, boolean encrypt, BlockCipher.Encryptor dataEncryptor, byte[] AAD2) throws IOException {
        BytesInput data = this.readBlock(payloadLength, reader);
        if (compressor != null) {
            if (isCompressed) {
                data = decompressor.decompress(data, rawDataLength);
            }
            data = compressor.compress(data);
        }
        if (!encrypt) {
            return data.toByteArray();
        }
        return dataEncryptor.encrypt(data.toByteArray(), AAD2);
    }

    public BytesInput readBlock(int length, CompressionConverter.TransParquetFileReader reader) throws IOException {
        byte[] data = length > 0x200000 ? new byte[length] : this.pageBuffer;
        reader.blockRead(data, 0, length);
        return BytesInput.from(data, 0, length);
    }

    public BytesInput readBlockAllocate(int length, CompressionConverter.TransParquetFileReader reader) throws IOException {
        byte[] data = new byte[length];
        reader.blockRead(data, 0, length);
        return BytesInput.from(data, 0, length);
    }

    private int toIntWithCheck(long size) {
        if ((long)((int)size) != size) {
            throw new ParquetEncodingException("size is bigger than 2147483647 bytes: " + size);
        }
        return (int)size;
    }

    private void getPaths(GroupType schema, List<String> paths, String parent) {
        List<Type> fields = schema.getFields();
        String prefix = parent == null ? "" : parent + ".";
        for (Type field : fields) {
            paths.add(prefix + field.getName());
            if (!(field instanceof GroupType)) continue;
            this.getPaths(field.asGroupType(), paths, prefix + field.getName());
        }
    }

    private MessageType pruneColumnsInSchema(MessageType schema, Set<ColumnPath> prunePaths) {
        List<Type> fields = schema.getFields();
        ArrayList<String> currentPath = new ArrayList<String>();
        List<Type> prunedFields = this.pruneColumnsInFields(fields, currentPath, prunePaths);
        MessageType newSchema = new MessageType(schema.getName(), prunedFields);
        return newSchema;
    }

    private List<Type> pruneColumnsInFields(List<Type> fields, List<String> currentPath, Set<ColumnPath> prunePaths) {
        ArrayList<Type> prunedFields = new ArrayList<Type>();
        for (Type childField : fields) {
            Type prunedChildField = this.pruneColumnsInField(childField, currentPath, prunePaths);
            if (prunedChildField == null) continue;
            prunedFields.add(prunedChildField);
        }
        return prunedFields;
    }

    private Type pruneColumnsInField(Type field, List<String> currentPath, Set<ColumnPath> prunePaths) {
        String fieldName = field.getName();
        currentPath.add(fieldName);
        ColumnPath path = ColumnPath.get(currentPath.toArray(new String[0]));
        Type prunedField = null;
        if (!prunePaths.contains(path)) {
            if (field.isPrimitive()) {
                prunedField = field;
            } else {
                List<Type> childFields = ((GroupType)field).getFields();
                List<Type> prunedFields = this.pruneColumnsInFields(childFields, currentPath, prunePaths);
                if (prunedFields.size() > 0) {
                    prunedField = ((GroupType)field).withNewFields(prunedFields);
                }
            }
        }
        currentPath.remove(currentPath.size() - 1);
        return prunedField;
    }

    private Set<ColumnPath> convertToColumnPaths(List<String> cols) {
        HashSet<ColumnPath> prunePaths = new HashSet<ColumnPath>();
        for (String col : cols) {
            prunePaths.add(ColumnPath.fromDotString(col));
        }
        return prunePaths;
    }

    private void nullifyColumn(ColumnDescriptor descriptor, ColumnChunkMetaData chunk, ColumnReadStoreImpl crStore, ParquetFileWriter writer, MessageType schema, CompressionCodecName newCodecName, boolean encryptColumn) throws IOException {
        if (encryptColumn) {
            Preconditions.checkArgument(writer.getEncryptor() != null, "Missing encryptor");
        }
        long totalChunkValues = chunk.getValueCount();
        int dMax = descriptor.getMaxDefinitionLevel();
        ColumnReader cReader = crStore.getColumnReader(descriptor);
        ParquetProperties.WriterVersion writerVersion = chunk.getEncodingStats().usesV2Pages() ? ParquetProperties.WriterVersion.PARQUET_2_0 : ParquetProperties.WriterVersion.PARQUET_1_0;
        ParquetProperties props = ParquetProperties.builder().withWriterVersion(writerVersion).build();
        CodecFactory codecFactory = new CodecFactory(new Configuration(), props.getPageSizeThreshold());
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(newCodecName);
        MessageType newSchema = this.newSchema(schema, descriptor);
        ColumnChunkPageWriteStore cPageStore = new ColumnChunkPageWriteStore(compressor, newSchema, props.getAllocator(), props.getColumnIndexTruncateLength(), props.getPageWriteChecksumEnabled(), writer.getEncryptor(), this.numBlocksRewritten);
        ColumnWriteStore cStore = props.newColumnWriteStore(newSchema, cPageStore);
        ColumnWriter cWriter = cStore.getColumnWriter(descriptor);
        int i = 0;
        while ((long)i < totalChunkValues) {
            int rlvl = cReader.getCurrentRepetitionLevel();
            int dlvl = cReader.getCurrentDefinitionLevel();
            if (dlvl == dMax) {
                if (dlvl == 0) {
                    throw new IOException("definition level is detected to be 0 for column " + chunk.getPath().toDotString() + " to be nullified");
                }
                if (rlvl == 0) {
                    cWriter.writeNull(rlvl, dlvl - 1);
                }
            } else {
                cWriter.writeNull(rlvl, dlvl);
            }
            cStore.endRecord();
            ++i;
        }
        cStore.flush();
        cPageStore.flushToFileWriter(writer);
        cStore.close();
        cWriter.close();
    }

    private MessageType newSchema(MessageType schema, ColumnDescriptor descriptor) {
        String[] path = descriptor.getPath();
        Type type = schema.getType(path);
        if (path.length == 1) {
            return new MessageType(schema.getName(), type);
        }
        for (Type field : schema.getFields()) {
            Type newType;
            if (field.isPrimitive() || (newType = this.extractField(field.asGroupType(), type)) == null) continue;
            return new MessageType(schema.getName(), newType);
        }
        throw new RuntimeException("No field is found");
    }

    private Type extractField(GroupType candidate, Type targetField) {
        if (targetField.equals((Object)candidate)) {
            return targetField;
        }
        for (Type field : candidate.asGroupType().getFields()) {
            if (field.isPrimitive()) {
                if (!field.equals((Object)targetField)) continue;
                return new GroupType(candidate.getRepetition(), candidate.getName(), targetField);
            }
            Type tempField = this.extractField(field.asGroupType(), targetField);
            if (tempField == null) continue;
            return tempField;
        }
        return null;
    }

    private static class ColumnChunkEncryptorRunTime {
        private final InternalColumnEncryptionSetup colEncrSetup;
        private final BlockCipher.Encryptor dataEncryptor;
        private final BlockCipher.Encryptor metaDataEncryptor;
        private final byte[] fileAAD;
        private byte[] dataPageHeaderAAD;
        private byte[] dataPageAAD;
        private byte[] dictPageHeaderAAD;
        private byte[] dictPageAAD;

        public ColumnChunkEncryptorRunTime(InternalFileEncryptor fileEncryptor, ColumnChunkMetaData chunk, int blockId, int columnId) throws IOException {
            Preconditions.checkArgument(fileEncryptor != null, "FileEncryptor is required to create ColumnChunkEncryptorRunTime");
            this.colEncrSetup = fileEncryptor.getColumnSetup(chunk.getPath(), true, columnId);
            this.dataEncryptor = this.colEncrSetup.getDataEncryptor();
            this.metaDataEncryptor = this.colEncrSetup.getMetaDataEncryptor();
            this.fileAAD = fileEncryptor.getFileAAD();
            if (this.colEncrSetup != null && this.colEncrSetup.isEncrypted()) {
                this.dataPageHeaderAAD = this.createAAD(ModuleCipherFactory.ModuleType.DataPageHeader, blockId, columnId);
                this.dataPageAAD = this.createAAD(ModuleCipherFactory.ModuleType.DataPage, blockId, columnId);
                this.dictPageHeaderAAD = this.createAAD(ModuleCipherFactory.ModuleType.DictionaryPageHeader, blockId, columnId);
                this.dictPageAAD = this.createAAD(ModuleCipherFactory.ModuleType.DictionaryPage, blockId, columnId);
            } else {
                this.dataPageHeaderAAD = null;
                this.dataPageAAD = null;
                this.dictPageHeaderAAD = null;
                this.dictPageAAD = null;
            }
        }

        private byte[] createAAD(ModuleCipherFactory.ModuleType moduleType, int blockId, int columnId) {
            return AesCipher.createModuleAAD(this.fileAAD, moduleType, blockId, columnId, 0);
        }

        public BlockCipher.Encryptor getDataEncryptor() {
            return this.dataEncryptor;
        }

        public BlockCipher.Encryptor getMetaDataEncryptor() {
            return this.metaDataEncryptor;
        }

        public byte[] getDataPageHeaderAAD() {
            return this.dataPageHeaderAAD;
        }

        public byte[] getDataPageAAD() {
            return this.dataPageAAD;
        }

        public byte[] getDictPageHeaderAAD() {
            return this.dictPageHeaderAAD;
        }

        public byte[] getDictPageAAD() {
            return this.dictPageAAD;
        }
    }

    private static final class DummyConverter
    extends PrimitiveConverter {
        private DummyConverter() {
        }

        @Override
        public GroupConverter asGroupConverter() {
            return new DummyGroupConverter();
        }
    }

    private static final class DummyGroupConverter
    extends GroupConverter {
        private DummyGroupConverter() {
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return new DummyConverter();
        }
    }
}

