/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.parquet.hadoop.codec.Lz4RawCompressor;
import org.apache.parquet.hadoop.codec.Lz4RawDecompressor;
import org.apache.parquet.hadoop.codec.NonBlockedCompressorStream;
import org.apache.parquet.hadoop.codec.NonBlockedDecompressorStream;

public class Lz4RawCodec
implements Configurable,
CompressionCodec {
    private Configuration conf;
    public static final String BUFFER_SIZE_CONFIG = "io.file.buffer.size";
    private static final int DEFAULT_BUFFER_SIZE_CONFIG = 4096;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Compressor createCompressor() {
        return new Lz4RawCompressor();
    }

    @Override
    public Decompressor createDecompressor() {
        return new Lz4RawDecompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream) throws IOException {
        return this.createInputStream(stream, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream, Decompressor decompressor) throws IOException {
        return new NonBlockedDecompressorStream(stream, decompressor, this.conf.getInt(BUFFER_SIZE_CONFIG, 4096));
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream) throws IOException {
        return this.createOutputStream(stream, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream, Compressor compressor) throws IOException {
        return new NonBlockedCompressorStream(stream, compressor, this.conf.getInt(BUFFER_SIZE_CONFIG, 4096));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return Lz4RawCompressor.class;
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return Lz4RawDecompressor.class;
    }

    @Override
    public String getDefaultExtension() {
        return ".lz4";
    }
}

