/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AOpContext;
import org.apache.hadoop.fs.s3a.VectoredIOContext;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public class S3AReadOpContext
extends S3AOpContext {
    private final Path path;
    private S3AInputPolicy inputPolicy;
    private ChangeDetectionPolicy changeDetectionPolicy;
    private long readahead;
    private AuditSpan auditSpan;
    private long asyncDrainThreshold;
    private final VectoredIOContext vectoredIOContext;
    private final IOStatisticsAggregator ioStatisticsAggregator;

    public S3AReadOpContext(Path path, Invoker invoker, @Nullable FileSystem.Statistics stats, S3AStatisticsContext instrumentation, FileStatus dstFileStatus, VectoredIOContext vectoredIOContext, IOStatisticsAggregator ioStatisticsAggregator) {
        super(invoker, stats, instrumentation, dstFileStatus);
        this.path = Objects.requireNonNull(path);
        this.vectoredIOContext = Objects.requireNonNull(vectoredIOContext, "vectoredIOContext");
        this.ioStatisticsAggregator = ioStatisticsAggregator;
    }

    public S3AReadOpContext build() {
        Objects.requireNonNull(this.inputPolicy, "inputPolicy");
        Objects.requireNonNull(this.changeDetectionPolicy, "changeDetectionPolicy");
        Objects.requireNonNull(this.auditSpan, "auditSpan");
        Objects.requireNonNull(this.inputPolicy, "inputPolicy");
        Preconditions.checkArgument(this.readahead >= 0L, "invalid readahead %d", this.readahead);
        Preconditions.checkArgument(this.asyncDrainThreshold >= 0L, "invalid drainThreshold %d", this.asyncDrainThreshold);
        Objects.requireNonNull(this.ioStatisticsAggregator, "ioStatisticsAggregator");
        return this;
    }

    public Invoker getReadInvoker() {
        return this.invoker;
    }

    public Path getPath() {
        return this.path;
    }

    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    public ChangeDetectionPolicy getChangeDetectionPolicy() {
        return this.changeDetectionPolicy;
    }

    public long getReadahead() {
        return this.readahead;
    }

    public AuditSpan getAuditSpan() {
        return this.auditSpan;
    }

    public S3AReadOpContext withInputPolicy(S3AInputPolicy value) {
        this.inputPolicy = value;
        return this;
    }

    public S3AReadOpContext withChangeDetectionPolicy(ChangeDetectionPolicy value) {
        this.changeDetectionPolicy = value;
        return this;
    }

    public S3AReadOpContext withReadahead(long value) {
        this.readahead = value;
        return this;
    }

    public S3AReadOpContext withAuditSpan(AuditSpan value) {
        this.auditSpan = value;
        return this;
    }

    public S3AReadOpContext withAsyncDrainThreshold(long value) {
        this.asyncDrainThreshold = value;
        return this;
    }

    public long getAsyncDrainThreshold() {
        return this.asyncDrainThreshold;
    }

    public VectoredIOContext getVectoredIOContext() {
        return this.vectoredIOContext;
    }

    public IOStatisticsAggregator getIOStatisticsAggregator() {
        return this.ioStatisticsAggregator;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("S3AReadOpContext{");
        sb.append("path=").append(this.path);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", readahead=").append(this.readahead);
        sb.append(", changeDetectionPolicy=").append(this.changeDetectionPolicy);
        sb.append('}');
        return sb.toString();
    }
}

