/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document;

import com.amazonaws.services.dynamodbv2.document.IncompatibleTypeException;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.internal.ItemValueConformer;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.json.Jackson;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Item {
    private static final String DUPLICATE_VALUES_FOUND_IN_INPUT = "Duplicate values found in input";
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private static final ItemValueConformer valueConformer = new ItemValueConformer();

    public boolean isNull(String attrName) {
        return this.attributes.containsKey(attrName) && this.attributes.get(attrName) == null;
    }

    public boolean isPresent(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    public String getString(String attrName) {
        Object val = this.attributes.get(attrName);
        return InternalUtils.valToString(val);
    }

    public Item withString(String attrName, String val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, val);
        return this;
    }

    public BigDecimal getNumber(String attrName) {
        Object val = this.attributes.get(attrName);
        return this.toBigDecimal(val);
    }

    private BigDecimal toBigDecimal(Object val) {
        if (val == null) {
            return null;
        }
        return val instanceof BigDecimal ? (BigDecimal)val : new BigDecimal(val.toString());
    }

    public BigInteger getBigInteger(String attrName) {
        BigDecimal bd = this.getNumber(attrName);
        return bd == null ? null : bd.toBigInteger();
    }

    public short getShort(String attrName) {
        BigDecimal bd = this.getNumber(attrName);
        if (bd == null) {
            throw new NumberFormatException("value of " + attrName + " is null");
        }
        return bd.shortValue();
    }

    public int getInt(String attrName) {
        BigDecimal bd = this.getNumber(attrName);
        if (bd == null) {
            throw new NumberFormatException("value of " + attrName + " is null");
        }
        return bd.intValue();
    }

    public long getLong(String attrName) {
        BigDecimal bd = this.getNumber(attrName);
        if (bd == null) {
            throw new NumberFormatException("value of " + attrName + " is null");
        }
        return bd.longValue();
    }

    public float getFloat(String attrName) {
        BigDecimal bd = this.getNumber(attrName);
        if (bd == null) {
            throw new NumberFormatException("value of " + attrName + " is null");
        }
        return bd.floatValue();
    }

    public double getDouble(String attrName) {
        BigDecimal bd = this.getNumber(attrName);
        if (bd == null) {
            throw new NumberFormatException("value of " + attrName + " is null");
        }
        return bd.doubleValue();
    }

    public Item withNumber(String attrName, BigDecimal val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, val);
        return this;
    }

    public Item withNumber(String attrName, Number val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, this.toBigDecimal(val));
        return this;
    }

    public Item withInt(String attrName, int val) {
        InternalUtils.checkInvalidAttrName(attrName);
        return this.withNumber(attrName, val);
    }

    public Item withBigInteger(String attrName, BigInteger val) {
        InternalUtils.checkInvalidAttrName(attrName);
        return this.withNumber(attrName, val);
    }

    public Item withShort(String attrName, short val) {
        InternalUtils.checkInvalidAttrName(attrName);
        return this.withNumber(attrName, val);
    }

    public Item withFloat(String attrName, float val) {
        InternalUtils.checkInvalidAttrName(attrName);
        return this.withNumber(attrName, Float.valueOf(val));
    }

    public Item withDouble(String attrName, double val) {
        InternalUtils.checkInvalidAttrName(attrName);
        return this.withNumber(attrName, val);
    }

    public Item withLong(String attrName, long val) {
        InternalUtils.checkInvalidAttrName(attrName);
        return this.withNumber(attrName, val);
    }

    public byte[] getBinary(String attrName) {
        Object val = this.attributes.get(attrName);
        return this.toByteArray(val);
    }

    public ByteBuffer getByteBuffer(String attrName) {
        Object val = this.attributes.get(attrName);
        return this.toByteBuffer(val);
    }

    private byte[] toByteArray(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        if (val instanceof ByteBuffer) {
            return BinaryUtils.copyAllBytesFrom((ByteBuffer)val);
        }
        throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a byte array");
    }

    private ByteBuffer toByteBuffer(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return ByteBuffer.wrap((byte[])val);
        }
        if (val instanceof ByteBuffer) {
            return (ByteBuffer)val;
        }
        throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a ByteBuffer");
    }

    public Item withBinary(String attrName, byte[] val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, val);
        return this;
    }

    public Item withBinary(String attrName, ByteBuffer val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, BinaryUtils.copyBytesFrom(val));
        return this;
    }

    public Set<String> getStringSet(String attrName) {
        Object val = this.attributes.get(attrName);
        if (val == null) {
            return null;
        }
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>();
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() == 0) {
                return stringSet;
            }
            for (Object element : col) {
                String s2 = element == null ? null : InternalUtils.valToString(element);
                if (stringSet.add(s2)) continue;
                throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a set of strings because of duplicate elements");
            }
            return stringSet;
        }
        stringSet.add(InternalUtils.valToString(val));
        return stringSet;
    }

    public Item withStringSet(String attrName, Set<String> val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, val);
        return this;
    }

    public Item withStringSet(String attrName, String ... val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        LinkedHashSet<String> strSet = new LinkedHashSet<String>(Arrays.asList(val));
        if (strSet.size() != val.length) {
            throw new IllegalArgumentException(DUPLICATE_VALUES_FOUND_IN_INPUT);
        }
        this.attributes.put(attrName, strSet);
        return this;
    }

    public Set<BigDecimal> getNumberSet(String attrName) {
        Object val = this.attributes.get(attrName);
        if (val == null) {
            return null;
        }
        LinkedHashSet<BigDecimal> numSet = new LinkedHashSet<BigDecimal>();
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() == 0) {
                return numSet;
            }
            for (Object element : col) {
                BigDecimal bd = this.toBigDecimal(element);
                if (numSet.add(bd)) continue;
                throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a set of BigDecimal's because of duplicate elements");
            }
            return numSet;
        }
        if (val instanceof BigDecimal) {
            numSet.add((BigDecimal)val);
            return numSet;
        }
        numSet.add(new BigDecimal(val.toString()));
        return numSet;
    }

    public Item withBigDecimalSet(String attrName, Set<BigDecimal> val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, val);
        return this;
    }

    public Item withBigDecimalSet(String attrName, BigDecimal ... vals) {
        InternalUtils.checkInvalidAttribute(attrName, vals);
        LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(Arrays.asList(vals));
        if (set.size() != vals.length) {
            throw new IllegalArgumentException(DUPLICATE_VALUES_FOUND_IN_INPUT);
        }
        this.attributes.put(attrName, set);
        return this;
    }

    public Item withNumberSet(String attrName, Number ... vals) {
        InternalUtils.checkInvalidAttribute(attrName, vals);
        Set<BigDecimal> set = InternalUtils.toBigDecimalSet(vals);
        if (set.size() != vals.length) {
            throw new IllegalArgumentException(DUPLICATE_VALUES_FOUND_IN_INPUT);
        }
        return this.withBigDecimalSet(attrName, set);
    }

    public Item withNumberSet(String attrName, Set<Number> vals) {
        InternalUtils.checkInvalidAttribute(attrName, vals);
        Set<BigDecimal> set = InternalUtils.toBigDecimalSet(vals);
        if (set.size() != vals.size()) {
            throw new IllegalArgumentException(DUPLICATE_VALUES_FOUND_IN_INPUT);
        }
        return this.withBigDecimalSet(attrName, set);
    }

    public Set<byte[]> getBinarySet(String attrName) {
        Object val = this.attributes.get(attrName);
        if (val == null) {
            return null;
        }
        LinkedHashSet<byte[]> binarySet = new LinkedHashSet<byte[]>();
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() == 0) {
                return binarySet;
            }
            for (Object element : col) {
                byte[] ba = this.toByteArray(element);
                if (binarySet.add(ba)) continue;
                throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a set of byte arrays because of duplicate elements");
            }
            return binarySet;
        }
        if (val instanceof byte[]) {
            binarySet.add((byte[])val);
            return binarySet;
        }
        if (val instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)val;
            binarySet.add(BinaryUtils.copyAllBytesFrom(bb));
            return binarySet;
        }
        throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a set of byte arrays");
    }

    public Set<ByteBuffer> getByteBufferSet(String attrName) {
        Object val = this.attributes.get(attrName);
        if (val == null) {
            return null;
        }
        LinkedHashSet<ByteBuffer> binarySet = new LinkedHashSet<ByteBuffer>();
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() == 0) {
                return binarySet;
            }
            for (Object element : col) {
                ByteBuffer ba = this.toByteBuffer(element);
                if (binarySet.add(ba)) continue;
                throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a set of ByteBuffer because of duplicate elements");
            }
            return binarySet;
        }
        if (val instanceof ByteBuffer) {
            binarySet.add((ByteBuffer)val);
            return binarySet;
        }
        if (val instanceof byte[]) {
            binarySet.add(ByteBuffer.wrap((byte[])val));
            return binarySet;
        }
        throw new IncompatibleTypeException(val.getClass() + " cannot be converted into a set of ByteBuffer");
    }

    public Item withBinarySet(String attrName, Set<byte[]> val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, val);
        return this;
    }

    public Item withByteBufferSet(String attrName, Set<ByteBuffer> val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        LinkedHashSet<byte[]> set = new LinkedHashSet<byte[]>(val.size());
        for (ByteBuffer bb : val) {
            set.add(BinaryUtils.copyBytesFrom(bb));
        }
        this.attributes.put(attrName, set);
        return this;
    }

    public Item withBinarySet(String attrName, byte[] ... vals) {
        InternalUtils.checkInvalidAttribute(attrName, vals);
        LinkedHashSet set = new LinkedHashSet(Arrays.asList(vals));
        if (set.size() != vals.length) {
            throw new IllegalArgumentException(DUPLICATE_VALUES_FOUND_IN_INPUT);
        }
        this.attributes.put(attrName, set);
        return this;
    }

    public Item withBinarySet(String attrName, ByteBuffer ... vals) {
        InternalUtils.checkInvalidAttribute(attrName, vals);
        LinkedHashSet<byte[]> set = new LinkedHashSet<byte[]>(vals.length);
        for (ByteBuffer bb : vals) {
            set.add(BinaryUtils.copyBytesFrom(bb));
        }
        if (set.size() != vals.length) {
            throw new IllegalArgumentException(DUPLICATE_VALUES_FOUND_IN_INPUT);
        }
        this.attributes.put(attrName, set);
        return this;
    }

    public <T> List<T> getList(String attrName) {
        Object val = this.attributes.get(attrName);
        if (val == null) {
            return null;
        }
        if (val instanceof List) {
            List ret = (List)val;
            return ret;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                Object element;
                Object t2 = element = iterator.next();
                list.add(t2);
            }
            return list;
        }
        Object t3 = val;
        list.add(t3);
        return list;
    }

    public Item withList(String attrName, List<?> val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, valueConformer.transform(val));
        return this;
    }

    public Item withList(String attrName, Object ... vals) {
        InternalUtils.checkInvalidAttribute(attrName, vals);
        List<Object> list_in = Arrays.asList(vals);
        this.attributes.put(attrName, valueConformer.transform(list_in));
        return this;
    }

    public <T> Map<String, T> getMap(String attrName) {
        return (Map)this.attributes.get(attrName);
    }

    public <T extends Number> Map<String, T> getMapOfNumbers(String attrName, Class<T> valueType) {
        if (valueType == Short.class || valueType == Integer.class || valueType == Long.class || valueType == Float.class || valueType == Double.class || valueType == Number.class || valueType == BigDecimal.class || valueType == BigInteger.class) {
            Map src = (Map)this.attributes.get(attrName);
            if (src == null) {
                return null;
            }
            LinkedHashMap<String, Number> dst = new LinkedHashMap<String, Number>(src.size());
            for (Map.Entry e : src.entrySet()) {
                String key = (String)e.getKey();
                BigDecimal val = (BigDecimal)e.getValue();
                if (val == null) {
                    dst.put(key, null);
                    continue;
                }
                if (valueType == Short.class) {
                    dst.put(key, val.shortValue());
                    continue;
                }
                if (valueType == Integer.class) {
                    dst.put(key, val.intValue());
                    continue;
                }
                if (valueType == Long.class) {
                    dst.put(key, val.longValue());
                    continue;
                }
                if (valueType == Float.class) {
                    dst.put(key, Float.valueOf(val.floatValue()));
                    continue;
                }
                if (valueType == Double.class) {
                    dst.put(key, val.doubleValue());
                    continue;
                }
                if (valueType == BigDecimal.class || valueType == Number.class) {
                    dst.put(key, val);
                    continue;
                }
                if (valueType != BigInteger.class) continue;
                dst.put(key, val.toBigInteger());
            }
            return dst;
        }
        throw new UnsupportedOperationException("Value type " + valueType + " is not currently supported");
    }

    public Map<String, Object> getRawMap(String attrName) {
        return (Map)this.attributes.get(attrName);
    }

    public Item withMap(String attrName, Map<String, ?> val) {
        InternalUtils.checkInvalidAttribute(attrName, val);
        this.attributes.put(attrName, valueConformer.transform(val));
        return this;
    }

    public Item withJSON(String attrName, String json) {
        InternalUtils.checkInvalidAttribute(attrName, json);
        this.attributes.put(attrName, valueConformer.transform(Jackson.fromJsonString(json, Object.class)));
        return this;
    }

    public String getJSON(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        Object val = this.attributes.get(attrName);
        return val == null ? null : Jackson.toJsonString(val);
    }

    public String getJSONPretty(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        Object val = this.attributes.get(attrName);
        return val == null ? null : Jackson.toJsonPrettyString(val);
    }

    public Boolean getBOOL(String attrName) {
        Object val = this.attributes.get(attrName);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            if ("1".equals(val)) {
                return true;
            }
            if ("0".equals(val)) {
                return false;
            }
            return Boolean.valueOf((String)val);
        }
        throw new IncompatibleTypeException("Value of attribute " + attrName + " of type " + this.getTypeOf(attrName) + " cannot be converted into a boolean value");
    }

    public boolean getBoolean(String attrName) {
        Boolean b = this.getBOOL(attrName);
        return b;
    }

    public Item withBoolean(String attrName, boolean val) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attributes.put(attrName, val);
        return this;
    }

    public Item withNull(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attributes.put(attrName, null);
        return this;
    }

    public Item with(String attrName, Object val) {
        if (val == null) {
            return this.withNull(attrName);
        }
        if (val instanceof String) {
            return this.withString(attrName, (String)val);
        }
        if (val instanceof Number) {
            return this.withNumber(attrName, (Number)val);
        }
        if (val instanceof byte[]) {
            return this.withBinary(attrName, (byte[])val);
        }
        if (val instanceof ByteBuffer) {
            return this.withBinary(attrName, (ByteBuffer)val);
        }
        if (val instanceof Boolean) {
            return this.withBoolean(attrName, (Boolean)val);
        }
        if (val instanceof List) {
            return this.withList(attrName, (List)val);
        }
        if (val instanceof Map) {
            Map map = (Map)val;
            return this.withMap(attrName, map);
        }
        if (val instanceof Set) {
            Set bs;
            Set set = (Set)val;
            if (set.size() == 0) {
                Set ss = (Set)val;
                return this.withStringSet(attrName, ss);
            }
            Object representative = null;
            for (Object o : set) {
                if (o == null) continue;
                representative = o;
            }
            if (representative == null || representative instanceof String) {
                Set ss = (Set)val;
                return this.withStringSet(attrName, ss);
            }
            if (representative instanceof Number) {
                Set ns = (Set)val;
                return this.withNumberSet(attrName, ns);
            }
            if (representative instanceof byte[]) {
                bs = (Set)val;
                return this.withBinarySet(attrName, bs);
            }
            if (representative instanceof ByteBuffer) {
                bs = (Set)val;
                return this.withByteBufferSet(attrName, bs);
            }
            throw new UnsupportedOperationException("Set of " + representative.getClass() + " is not currently supported");
        }
        throw new UnsupportedOperationException("Input type " + val.getClass() + " is not currently supported");
    }

    public Item withPrimaryKey(PrimaryKey primaryKey) {
        InternalUtils.rejectNullValue(primaryKey);
        if (primaryKey.getComponents().size() == 0) {
            throw new IllegalArgumentException("primary key must not be empty");
        }
        for (KeyAttribute ka : primaryKey.getComponents()) {
            this.with(ka.getName(), ka.getValue());
        }
        return this;
    }

    public Item withPrimaryKey(String hashKeyName, Object hashKeyValue) {
        return this.withKeyComponent(hashKeyName, hashKeyValue);
    }

    public Item withPrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.withKeyComponent(hashKeyName, hashKeyValue).withKeyComponent(rangeKeyName, rangeKeyValue);
    }

    public Item withKeyComponents(KeyAttribute ... components) {
        InternalUtils.rejectNullOrEmptyInput(components);
        for (KeyAttribute ka : components) {
            InternalUtils.rejectNullValue(ka);
            this.with(ka.getName(), ka.getValue());
        }
        return this;
    }

    public Item withKeyComponent(String keyAttrName, Object keyAttrValue) {
        return this.with(keyAttrName, keyAttrValue);
    }

    public Object get(String attrName) {
        return this.attributes.get(attrName);
    }

    public Class<?> getTypeOf(String attrName) {
        Object val = this.attributes.get(attrName);
        return val == null ? null : val.getClass();
    }

    public Item removeAttribute(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attributes.remove(attrName);
        return this;
    }

    public Iterable<Map.Entry<String, Object>> attributes() {
        return new LinkedHashMap<String, Object>(this.attributes).entrySet();
    }

    public boolean hasAttribute(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    public Map<String, Object> asMap() {
        return new LinkedHashMap<String, Object>(this.attributes);
    }

    public int numberOfAttributes() {
        return this.attributes.size();
    }

    public static Item fromMap(Map<String, Object> attributes) {
        if (attributes == null) {
            return null;
        }
        Item item = new Item();
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            item.with(e.getKey(), e.getValue());
        }
        return item;
    }

    public static Item fromJSON(String json) {
        if (json == null) {
            return null;
        }
        Map map = (Map)valueConformer.transform(Jackson.fromJsonString(json, Map.class));
        return Item.fromMap(map);
    }

    public String toJSON() {
        return Jackson.toJsonString(this.attributes);
    }

    public Item base64Decode(String ... binaryAttrNames) {
        Set<String> b64s;
        String b64;
        InternalUtils.rejectNullInput(binaryAttrNames);
        for (String attrName : binaryAttrNames) {
            InternalUtils.checkInvalidAttrName(attrName);
            if (String.class == this.getTypeOf(attrName)) {
                b64 = this.getString(attrName);
                Base64.decode(b64);
                continue;
            }
            b64s = this.getStringSet(attrName);
            for (String b642 : b64s) {
                Base64.decode(b642);
            }
        }
        for (String attrName : binaryAttrNames) {
            if (String.class == this.getTypeOf(attrName)) {
                b64 = this.getString(attrName);
                byte[] bytes = Base64.decode(b64);
                this.withBinary(attrName, bytes);
                continue;
            }
            b64s = this.getStringSet(attrName);
            LinkedHashSet<byte[]> binarySet = new LinkedHashSet<byte[]>(b64s.size());
            for (String b643 : b64s) {
                binarySet.add(Base64.decode(b643));
            }
            this.withBinarySet(attrName, binarySet);
        }
        return this;
    }

    public Item convertListsToSets(String ... listAttrNames) {
        List list;
        InternalUtils.rejectNullInput(listAttrNames);
        for (String attrName : listAttrNames) {
            InternalUtils.checkInvalidAttrName(attrName);
            if (List.class.isAssignableFrom(this.getTypeOf(attrName))) {
                list = this.getList(attrName);
                if (list == null) continue;
                for (Object e : list) {
                    Set<Object> ss;
                    if (e instanceof String) {
                        ss = this.getStringSet(attrName);
                        if (list.size() == ss.size()) continue;
                        throw new IllegalArgumentException("List cannot be converted to Set due to duplicate elements");
                    }
                    if (e instanceof Number) {
                        ss = this.getNumberSet(attrName);
                        if (list.size() == ss.size()) continue;
                        throw new IllegalArgumentException("List cannot be converted to Set due to duplicate elements");
                    }
                    if (!(e instanceof byte[])) continue;
                    ss = this.getBinarySet(attrName);
                    if (list.size() == ss.size()) continue;
                    throw new IllegalArgumentException("List cannot be converted to Set due to duplicate elements");
                }
                continue;
            }
            throw new IllegalArgumentException("Attribute " + attrName + " is not a list");
        }
        for (String attrName : listAttrNames) {
            InternalUtils.checkInvalidAttrName(attrName);
            list = this.getList(attrName);
            if (list == null) continue;
            boolean converted = false;
            for (Object e : list) {
                Set<Object> set;
                if (e instanceof String) {
                    set = this.getStringSet(attrName);
                    this.withStringSet(attrName, set);
                    converted = true;
                    break;
                }
                if (e instanceof Number) {
                    set = this.getNumberSet(attrName);
                    this.withBigDecimalSet(attrName, set);
                    converted = true;
                    break;
                }
                if (!(e instanceof byte[])) continue;
                set = this.getBinarySet(attrName);
                this.withBinarySet(attrName, set);
                converted = true;
                break;
            }
            if (converted) continue;
            Set<String> set = this.getStringSet(attrName);
            this.withStringSet(attrName, set);
        }
        return this;
    }

    public String toJSONPretty() {
        return Jackson.toJsonPrettyString(this.attributes);
    }

    public String toString() {
        return "{ Item: " + this.attributes.toString() + " }";
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean equals(Object in) {
        if (in instanceof Item) {
            Item that = (Item)in;
            return this.attributes.equals(that.attributes);
        }
        return false;
    }
}

