/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTyped;
import com.hazelcast.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDBTypeConverted(converter=Converter.class)
@DynamoDBTyped(value=DynamoDBMapperFieldModel.DynamoDBAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBTypeConvertedJson {
    public Class<? extends Object> targetType() default void.class;

    public static final class Converter<T>
    implements DynamoDBTypeConverter<String, T> {
        private static final ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        private final Class<T> targetType;

        public Converter(Class<T> targetType, DynamoDBTypeConvertedJson annotation) {
            this.targetType = annotation.targetType() == Void.TYPE ? targetType : annotation.targetType();
        }

        @Override
        public final String convert(T object) {
            try {
                return mapper.writeValueAsString(object);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Unable to write object to JSON", e);
            }
        }

        @Override
        public final T unconvert(String object) {
            try {
                return mapper.readValue(object, this.targetType);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Unable to read JSON string", e);
            }
        }
    }
}

