/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.securestore.impl;

import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.spi.impl.securestore.SecureStoreException;
import com.hazelcast.spi.impl.securestore.impl.AbstractSecureStore;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;

public class JavaKeyStoreSecureStore
extends AbstractSecureStore {
    protected final JavaKeyStoreSecureStoreConfig config;

    JavaKeyStoreSecureStore(@Nonnull JavaKeyStoreSecureStoreConfig config, @Nonnull Node node) {
        super(config.getPollingInterval(), node);
        this.config = config;
    }

    private static KeyStore loadKeyStore(JavaKeyStoreSecureStoreConfig config) {
        KeyStore keyStore;
        FileInputStream in = null;
        try {
            in = new FileInputStream(config.getPath());
            KeyStore ks = KeyStore.getInstance(config.getType());
            ks.load(in, JavaKeyStoreSecureStore.toCharArray(config.getPassword()));
            keyStore = ks;
        }
        catch (IOException | GeneralSecurityException e) {
            try {
                throw new SecureStoreException("Failed to load Java KeyStore", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(in);
                throw throwable;
            }
        }
        IOUtil.closeResource(in);
        return keyStore;
    }

    @Override
    @Nonnull
    public List<byte[]> retrieveEncryptionKeys() {
        KeyStore ks = JavaKeyStoreSecureStore.loadKeyStore(this.config);
        try {
            Enumeration<String> aliases = ks.aliases();
            char[] password = JavaKeyStoreSecureStore.toCharArray(this.config.getPassword());
            String currentKeyAlias = this.config.getCurrentKeyAlias();
            Comparator<String> comparator = JavaKeyStoreSecureStore.getComparator(currentKeyAlias);
            TreeSet<String> ordered = new TreeSet<String>(comparator);
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || ks.getCertificateChain(alias) != null) continue;
                ordered.add(alias);
            }
            if (currentKeyAlias != null && !ordered.isEmpty() && !currentKeyAlias.equals(ordered.iterator().next())) {
                throw new SecureStoreException("Current encryption key entry not found: " + currentKeyAlias);
            }
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            for (String alias : ordered) {
                Key key = ks.getKey(alias, password);
                assert (key instanceof SecretKey);
                keys.add(key.getEncoded());
            }
            return keys;
        }
        catch (GeneralSecurityException e) {
            throw new SecureStoreException("Failed to retrieve encryption keys", e);
        }
    }

    private static Comparator<String> getComparator(String currentKeyAlias) {
        return currentKeyAlias == null ? Comparator.reverseOrder() : (o1, o2) -> {
            if (currentKeyAlias.equals(o1)) {
                return -1;
            }
            if (currentKeyAlias.equals(o2)) {
                return 1;
            }
            return o1.compareTo((String)o2);
        };
    }

    protected byte[] retrieveCurrentEncryptionKey() {
        List<byte[]> keys = this.retrieveEncryptionKeys();
        return keys.isEmpty() ? null : keys.get(0);
    }

    private static char[] toCharArray(String str) {
        return str == null ? null : str.toCharArray();
    }

    @Override
    protected Runnable getWatcher() {
        return new KeyStoreWatcher();
    }

    private final class KeyStoreWatcher
    implements Runnable {
        private final MessageDigest md;
        private byte[] lastChecksum;
        private byte[] lastKey;

        protected KeyStoreWatcher() {
            try {
                this.md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecureStoreException("Failed to construct a MessageDigest object", e);
            }
            this.lastChecksum = this.checksum();
            this.lastKey = JavaKeyStoreSecureStore.this.retrieveCurrentEncryptionKey();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private byte[] checksum() {
            this.md.reset();
            byte[] buffer = new byte[1024];
            try (DigestInputStream dis = new DigestInputStream(Files.newInputStream(JavaKeyStoreSecureStore.this.config.getPath().toPath(), StandardOpenOption.READ), this.md);){
                int len;
                while ((len = dis.read(buffer, 0, buffer.length)) != -1) {
                }
                byte[] byArray = this.md.digest();
                return byArray;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new SecureStoreException("Failed to calculate KeyStore file checksum", e);
            }
        }

        @Override
        public void run() {
            try {
                byte[] currentChecksum = this.checksum();
                if (!(currentChecksum == null || this.lastChecksum != null && Arrays.equals(this.lastChecksum, currentChecksum))) {
                    JavaKeyStoreSecureStore.this.logger.fine("Java KeyStore change detected: " + JavaKeyStoreSecureStore.this.config.getPath());
                    this.lastChecksum = currentChecksum;
                    byte[] key = JavaKeyStoreSecureStore.this.retrieveCurrentEncryptionKey();
                    if (key != null && !Arrays.equals(key, this.lastKey)) {
                        JavaKeyStoreSecureStore.this.logger.info("Java KeyStore encryption key change detected: " + JavaKeyStoreSecureStore.this.config.getPath());
                        JavaKeyStoreSecureStore.this.notifyEncryptionKeyListeners(key);
                    }
                }
            }
            catch (Exception e) {
                JavaKeyStoreSecureStore.this.logger.warning("Error while detecting changes in Java KeyStore: " + JavaKeyStoreSecureStore.this.config.getPath());
            }
        }
    }
}

