/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl.weaksecretrules;

import com.hazelcast.security.impl.SecretStrengthRule;
import com.hazelcast.security.impl.WeakSecretError;
import java.util.EnumSet;
import java.util.regex.Pattern;

public class LargeKeySpaceRule
implements SecretStrengthRule {
    private static final Pattern SPECIAL_CHARACTER_PATTERN = Pattern.compile(".*?[^a-zA-Z0-9 ].*");

    @Override
    public EnumSet<WeakSecretError> check(CharSequence secret) {
        boolean hasAlpha = false;
        boolean hasNumeral = false;
        boolean hasLowerCase = false;
        boolean hasUpperCase = false;
        boolean hasSpecialChars = SPECIAL_CHARACTER_PATTERN.matcher(secret).matches();
        EnumSet<WeakSecretError> weaknesses = EnumSet.noneOf(WeakSecretError.class);
        for (int i = 0; i < secret.length(); ++i) {
            hasLowerCase |= Character.isLowerCase(secret.charAt(i));
            hasUpperCase |= Character.isUpperCase(secret.charAt(i));
            hasAlpha |= Character.isLetter(secret.charAt(i));
            hasNumeral |= Character.isDigit(secret.charAt(i));
        }
        if (!hasAlpha) {
            weaknesses.add(WeakSecretError.NO_ALPHA);
        }
        if (!hasNumeral) {
            weaknesses.add(WeakSecretError.NO_NUMERAL);
        }
        if (!hasSpecialChars) {
            weaknesses.add(WeakSecretError.NO_SPECIAL_CHARS);
        }
        if (!(hasLowerCase & hasUpperCase)) {
            weaknesses.add(WeakSecretError.NO_MIXED_CASE);
        }
        return weaknesses;
    }
}

