/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BaseSingleValueIndexStore;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.HDIndexHashMap;
import com.hazelcast.query.impl.HDIndexNestedTreeMap;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class HDOrderedIndexStore
extends BaseSingleValueIndexStore {
    private final HDIndexHashMap<QueryableEntry> recordsWithNullValue;
    private final HDIndexNestedTreeMap<QueryableEntry> records;

    HDOrderedIndexStore(EnterpriseSerializationService ess, MemoryAllocator malloc, MapEntryFactory<QueryableEntry> entryFactory) {
        super(IndexCopyBehavior.NEVER, false);
        ThreadUtil.assertRunningOnPartitionThread();
        this.recordsWithNullValue = new HDIndexHashMap<QueryableEntry>(ess, malloc, entryFactory);
        try {
            this.records = new HDIndexNestedTreeMap<QueryableEntry>(ess, malloc, entryFactory);
        }
        catch (NativeOutOfMemoryError e) {
            this.recordsWithNullValue.dispose();
            throw e;
        }
    }

    @Override
    Object insertInternal(Comparable attributeValue, QueryableEntry entry) {
        ThreadUtil.assertRunningOnPartitionThread();
        NativeMemoryData key = (NativeMemoryData)entry.getKeyData();
        NativeMemoryData value = (NativeMemoryData)entry.getValueData();
        if (attributeValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.put(key, value);
        }
        return this.records.put(attributeValue, key, value);
    }

    @Override
    Object removeInternal(Comparable attributeValue, Data key) {
        ThreadUtil.assertRunningOnPartitionThread();
        if (attributeValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.remove(key);
        }
        return this.records.remove(attributeValue, (NativeMemoryData)key);
    }

    @Override
    public void destroy() {
        ThreadUtil.assertRunningOnPartitionThread();
        try {
            this.clear();
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public boolean isEvaluateOnly() {
        return false;
    }

    @Override
    public boolean canEvaluate(Class<? extends Predicate> predicateClass) {
        return false;
    }

    @Override
    public Set<QueryableEntry> evaluate(Predicate predicate, TypeConverter converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return Comparables.canonicalizeForHashLookup(value);
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return value;
    }

    @Override
    public void clear() {
        ThreadUtil.assertRunningOnPartitionThread();
        this.recordsWithNullValue.clear();
        this.records.clear();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable value, boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable value, boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return this.doGetRecords(value);
    }

    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        HashSet<QueryableEntry> results = new HashSet<QueryableEntry>();
        for (Comparable value : values) {
            results.addAll(this.doGetRecords(value));
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable value) {
        Set<QueryableEntry> results;
        ThreadUtil.assertRunningOnPartitionThread();
        switch (comparison) {
            case LESS: {
                results = this.records.headMap(value, false);
                break;
            }
            case LESS_OR_EQUAL: {
                results = this.records.headMap(value, true);
                break;
            }
            case GREATER: {
                results = this.records.tailMap(value, false);
                break;
            }
            case GREATER_OR_EQUAL: {
                results = this.records.tailMap(value, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized comparison: " + (Object)((Object)comparison));
            }
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        ThreadUtil.assertRunningOnPartitionThread();
        return this.records.subMap(from, fromInclusive, to, toInclusive);
    }

    private void dispose() {
        this.recordsWithNullValue.dispose();
        this.records.dispose();
    }

    private Set<QueryableEntry> doGetRecords(Comparable value) {
        ThreadUtil.assertRunningOnPartitionThread();
        if (value == AbstractIndex.NULL) {
            return this.recordsWithNullValue.entrySet();
        }
        return this.records.get(value);
    }
}

