/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.bplustree.DefaultBPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotNoPayload;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.HDBaseConcurrentIndexStore;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Iterator;
import java.util.Set;

public class HDOrderedConcurrentIndexStore
extends HDBaseConcurrentIndexStore {
    HDOrderedConcurrentIndexStore(IndexCopyBehavior copyBehavior, EnterpriseSerializationService ess, MemoryAllocator keyAllocator, MemoryAllocator indexAllocator, MapEntryFactory<QueryableEntry> entryFactory, int nodeSize, boolean tstore) {
        super(copyBehavior, ess, keyAllocator, indexAllocator, new DefaultBPlusTreeKeyComparator(ess), entryFactory, nodeSize, new EntrySlotNoPayload(), tstore);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value) {
        if (value == AbstractIndex.NULL) {
            return this.recordsWithNullValue.getKeysInRangeBatch(null, true, null, true, false);
        }
        return this.records.getKeysInRangeBatch(value, true, value, true, false);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        Iterator<IndexKeyEntries> nullValues = this.recordsWithNullValue.getKeysInRangeBatch(null, true, null, true, descending);
        Iterator<IndexKeyEntries> nonNullValues = this.records.getKeysInRangeBatch(null, true, null, true, descending);
        if (descending) {
            return new HDBaseConcurrentIndexStore.ConcatIterator<IndexKeyEntries>(nonNullValues, nullValues);
        }
        return new HDBaseConcurrentIndexStore.ConcatIterator<IndexKeyEntries>(nullValues, nonNullValues);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable value, boolean descending) {
        switch (comparison) {
            case LESS: {
                return this.records.getKeysInRangeBatch(null, true, value, false, descending);
            }
            case LESS_OR_EQUAL: {
                return this.records.getKeysInRangeBatch(null, true, value, true, descending);
            }
            case GREATER: {
                return this.records.getKeysInRangeBatch(value, false, null, true, descending);
            }
            case GREATER_OR_EQUAL: {
                return this.records.getKeysInRangeBatch(value, true, null, true, descending);
            }
        }
        throw new IllegalArgumentException("Unrecognized comparison: " + (Object)((Object)comparison));
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.records.getKeysInRangeBatch(from, fromInclusive, to, toInclusive, descending);
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        return this.buildResultSet(this.getRecords0(from, fromInclusive, to, toInclusive, false));
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return Comparables.canonicalizeForHashLookup(value);
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return value;
    }
}

