/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema.internal;

import com.hazelcast.org.everit.json.schema.FormatValidator;
import com.hazelcast.org.everit.json.schema.JSONPointer;
import java.util.Optional;

public class RelativeJsonPointerFormatValidator
implements FormatValidator {
    @Override
    public Optional<String> validate(String subject) {
        try {
            new Parser(subject).parse();
        }
        catch (ParseException e) {
            return Optional.of(e.getMessage());
        }
        return Optional.empty();
    }

    @Override
    public String formatName() {
        return "relative-json-pointer";
    }

    private static final class Parser {
        public static final int EOF = 26;
        private String input;
        private int pos = 0;

        private static boolean isDigit(char c) {
            return '0' <= c && c <= '9';
        }

        public Parser(String input) {
            this.input = input;
        }

        public void parse() throws ParseException {
            this.parseUpwardsStepCount();
            this.parseJsonPointer();
            this.parseTrailingHashmark();
        }

        private void parseTrailingHashmark() throws ParseException {
            if (this.pos == this.input.length()) {
                return;
            }
            if (this.pos == this.input.length() - 1 && this.input.charAt(this.pos) == '#') {
                return;
            }
            this.fail();
        }

        private char next() {
            ++this.pos;
            if (this.pos == this.input.length()) {
                return '\u001a';
            }
            return this.curr();
        }

        private char curr() {
            if (this.pos == this.input.length()) {
                return '\u001a';
            }
            return this.input.charAt(this.pos);
        }

        private void parseUpwardsStepCount() throws ParseException {
            if (!Parser.isDigit(this.curr())) {
                this.fail();
            } else if (this.curr() == '0') {
                this.next();
                if (this.curr() == '/' || this.curr() == '#' || this.curr() == '\u001a') {
                    --this.pos;
                } else {
                    this.fail();
                }
            }
            char current = this.next();
            while (Parser.isDigit(current) && this.pos < this.input.length()) {
                current = this.next();
            }
        }

        private void fail() throws ParseException {
            throw new ParseException(this.input);
        }

        private void parseJsonPointer() throws ParseException {
            StringBuilder sb = new StringBuilder();
            char current = this.curr();
            while (this.pos < this.input.length() && current != '#') {
                sb.append(current);
                current = this.next();
            }
            String pointer = sb.toString();
            if (pointer.length() == 0) {
                return;
            }
            if (pointer.startsWith("#")) {
                this.fail();
            }
            try {
                new JSONPointer(pointer);
            }
            catch (IllegalArgumentException e) {
                this.fail();
            }
        }
    }

    private static class ParseException
    extends Exception {
        public ParseException(String input) {
            super(String.format("[%s] is not a valid relative JSON Pointer", input));
        }
    }
}

