/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MerkleTreeNodeEntries;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanEnterpriseMapMerkleTreeNode
extends WanEnterpriseMapEvent<Collection<EntryView<Object, Object>>> {
    private transient UUID uuid;
    private MerkleTreeNodeEntries entries;
    private transient int partitionId;

    public WanEnterpriseMapMerkleTreeNode() {
    }

    public WanEnterpriseMapMerkleTreeNode(UUID uuid, String mapName, MerkleTreeNodeEntries entries, int partitionId) {
        super(mapName, 0);
        this.uuid = uuid;
        this.entries = entries;
        this.partitionId = partitionId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public MerkleTreeNodeEntries getEntries() {
        return this.entries;
    }

    public void setEntries(MerkleTreeNodeEntries entries) {
        this.entries = entries;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.entries);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.entries = (MerkleTreeNodeEntries)in.readObject();
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.entries.getNodeEntries().iterator().next().getDataKey();
    }

    public int getEntryCount() {
        return this.entries.getNodeEntries().size();
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementSync(this.getMapName(), this.getEntryCount());
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.SYNC;
    }

    @Override
    @Nullable
    public Collection<EntryView<Object, Object>> getEventObject() {
        return this.getEntries().getNodeEntries();
    }
}

