/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import javax.annotation.Nonnull;

public class MerkleTreeUpdaterMutationObserver<R extends Record>
implements MutationObserver<R> {
    private final MerkleTree merkleTree;
    private final SerializationService serializationService;

    public MerkleTreeUpdaterMutationObserver(MerkleTree merkleTree, SerializationService serializationService) {
        this.merkleTree = merkleTree;
        this.serializationService = serializationService;
    }

    @Override
    public void onPutRecord(@Nonnull Data key, R record, Object oldValue, boolean backup) {
        this.updateAdd(key, record);
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, R record, boolean populateIndex) {
        this.updateAdd(key, record);
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, Object newValue, boolean backup) {
        this.updateReplace(key, oldValue, newValue);
    }

    @Override
    public void onRemoveRecord(Data key, R record, boolean backup) {
        this.updateRemove(key, record);
    }

    @Override
    public void onEvictRecord(Data key, R record, boolean backup) {
        this.updateRemove(key, record);
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        this.updateAdd(key, record);
    }

    @Override
    public void onReset() {
        this.clear();
    }

    @Override
    public void onClear() {
        this.clear();
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        this.clear();
    }

    private void updateAdd(@Nonnull Data key, R record) {
        this.merkleTree.updateAdd(key, this.asData(record.getValue()));
    }

    private void updateRemove(Data key, R record) {
        this.merkleTree.updateRemove(key, this.asData(record.getValue()));
    }

    private void updateReplace(@Nonnull Data key, Object oldValue, Object newValue) {
        this.merkleTree.updateReplace(key, this.asData(oldValue), this.asData(newValue));
    }

    private void clear() {
        this.merkleTree.clear();
    }

    private Data asData(Object value) {
        return this.serializationService.toData(value);
    }
}

