/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;

public class HDExpiryMetadata
extends HiDensityRecord
implements ExpiryMetadata {
    public static final int SIZE = 16;
    private static final int TTL_OFFSET = 0;
    private static final int MAX_IDLE_OFFSET = 4;
    private static final int EXPIRATION_TIME_OFFSET = 8;
    private static final int LAST_UPDATE_TIME_OFFSET = 12;

    public HDExpiryMetadata() {
        super(GlobalMemoryAccessorRegistry.AMEM);
    }

    public HDExpiryMetadata(long address) {
        super(GlobalMemoryAccessorRegistry.AMEM, address, SIZE);
    }

    @Override
    public long getValueAddress() {
        return 0L;
    }

    @Override
    public void setValueAddress(long valueAddress) {
    }

    @Override
    public HDExpiryMetadata reset(long address) {
        this.setAddress(address);
        this.setSize(SIZE);
        return this;
    }

    @Override
    public void clear() {
        this.zero();
    }

    @Override
    public long getSequence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTtl() {
        return ExpirationTimeSetter.toMillis(this.readInt(0L));
    }

    @Override
    public int getRawTtl() {
        return this.readInt(0L);
    }

    @Override
    public ExpiryMetadata setTtl(long ttl) {
        this.writeInt(0L, ExpirationTimeSetter.toSeconds(ttl));
        return this;
    }

    @Override
    public ExpiryMetadata setRawTtl(int ttl) {
        this.writeInt(0L, ttl);
        return this;
    }

    @Override
    public long getMaxIdle() {
        return ExpirationTimeSetter.toMillis(this.readInt(4L));
    }

    @Override
    public int getRawMaxIdle() {
        return this.readInt(4L);
    }

    @Override
    public ExpiryMetadata setMaxIdle(long maxIdle) {
        this.writeInt(4L, ExpirationTimeSetter.toSeconds(maxIdle));
        return this;
    }

    @Override
    public ExpiryMetadata setRawMaxIdle(int maxIdle) {
        this.writeInt(4L, maxIdle);
        return this;
    }

    @Override
    public long getExpirationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(8L));
    }

    @Override
    public int getRawExpirationTime() {
        return this.readInt(8L);
    }

    @Override
    public ExpiryMetadata setExpirationTime(long expirationTime) {
        this.writeInt(8L, TimeStripUtil.stripBaseTime(expirationTime));
        return this;
    }

    @Override
    public ExpiryMetadata setRawExpirationTime(int expirationTime) {
        this.writeInt(8L, expirationTime);
        return this;
    }

    @Override
    public long getLastUpdateTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(12L));
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.readInt(12L);
    }

    @Override
    public ExpiryMetadata setLastUpdateTime(long lastUpdateTime) {
        this.writeInt(12L, TimeStripUtil.stripBaseTime(lastUpdateTime));
        return this;
    }

    @Override
    public ExpiryMetadata setRawLastUpdateTime(int lastUpdateTime) {
        this.writeInt(12L, lastUpdateTime);
        return this;
    }

    @Override
    public String toString() {
        return "HDExpiryMetadata{ ttl= " + this.getTtl() + ", idle=" + this.getMaxIdle() + ", expirationTime=" + this.getExpirationTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + "}";
    }
}

