/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.elastic.map.SampleableElasticHashMap;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class HDStorageSCHM
extends SampleableElasticHashMap<HDRecord> {
    public static final int DEFAULT_CAPACITY = 128;
    public static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private final ExpirySystem expirySystem;
    private final SerializationService serializationService;

    public HDStorageSCHM(HiDensityRecordProcessor<HDRecord> recordProcessor, ExpirySystem expirySystem, SerializationService serializationService) {
        super(128, 0.6f, recordProcessor);
        this.expirySystem = expirySystem;
        this.serializationService = serializationService;
    }

    @Override
    protected <E extends SampleableElasticHashMap.SamplingEntry> E createSamplingEntry(int slot) {
        return (E)new LazyEvictableEntryView(slot, this.serializationService, this.expirySystem);
    }

    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        ArrayList<Data> keys = new ArrayList<Data>(size);
        IterationPointer[] newIterationPointers = this.fetchNext(pointers, size, (k, v) -> keys.add(this.memoryBlockProcessor.convertData((Data)k, DataType.HEAP)));
        return new MapKeysWithCursor((List<Data>)keys, newIterationPointers);
    }

    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        ArrayList<Map.Entry<Data, Data>> entries = new ArrayList<Map.Entry<Data, Data>>(size);
        IterationPointer[] newIterationPointers = this.fetchNext(pointers, size, (k, v) -> {
            Data heapKeyData = this.memoryBlockProcessor.convertData((Data)k, DataType.HEAP);
            Data heapValueData = this.memoryBlockProcessor.convertData((Data)v, DataType.HEAP);
            entries.add(new AbstractMap.SimpleEntry<Data, Data>(heapKeyData, heapValueData));
        });
        return new MapEntriesWithCursor((List<Map.Entry<Data, Data>>)entries, newIterationPointers);
    }

    private IterationPointer[] fetchNext(IterationPointer[] pointers, int size, BiConsumer<Data, Data> keyValueConsumer) {
        IterationPointer[] updatedPointers = this.checkPointers(pointers, this.capacity());
        IterationPointer lastPointer = updatedPointers[updatedPointers.length - 1];
        int currentBaseSlot = lastPointer.getIndex();
        int[] fetchedEntries = new int[]{0};
        while (fetchedEntries[0] < size && currentBaseSlot >= 0) {
            currentBaseSlot = this.fetchAllWithBaseSlot(currentBaseSlot, slot -> {
                long currentKey = this.accessor.getKey(slot);
                int currentKeyHashCode = NativeMemoryDataUtil.hashCode(currentKey);
                if (this.hasNotBeenObserved(currentKeyHashCode, updatedPointers)) {
                    long valueAddr = this.accessor.getValue(slot);
                    HDRecord record = (HDRecord)this.readV(valueAddr);
                    NativeMemoryData keyData = this.accessor.keyData(slot);
                    keyValueConsumer.accept(keyData, record.getValue());
                    fetchedEntries[0] = fetchedEntries[0] + 1;
                }
            });
            lastPointer.setIndex(currentBaseSlot);
        }
        return updatedPointers;
    }

    private IterationPointer[] checkPointers(IterationPointer[] pointers, int currentTableSize) {
        IterationPointer lastPointer = pointers[pointers.length - 1];
        boolean iterationStarted = lastPointer.getSize() == -1;
        boolean tableResized = lastPointer.getSize() != currentTableSize;
        int newLength = !iterationStarted && tableResized ? pointers.length + 1 : pointers.length;
        IterationPointer[] updatedPointers = new IterationPointer[newLength];
        for (int i = 0; i < pointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        if (iterationStarted || tableResized) {
            updatedPointers[updatedPointers.length - 1] = new IterationPointer(Integer.MAX_VALUE, currentTableSize);
        }
        return updatedPointers;
    }

    public class LazyEvictableEntryView<K, V>
    extends SampleableElasticHashMap.SamplingEntry
    implements EntryView<K, V> {
        private K key;
        private V value;
        private HDRecord record;
        private Data dataKey;
        private ExpiryMetadata expiryMetadata;
        private SerializationService serializationService;

        public LazyEvictableEntryView(int slot, SerializationService serializationService, ExpirySystem expirySystem) {
            super(slot);
            this.dataKey = super.getEntryKey();
            this.record = (HDRecord)super.getEntryValue();
            this.serializationService = serializationService;
            this.expiryMetadata = expirySystem.getExpiryMetadata(this.dataKey);
        }

        LazyEvictableEntryView(int slot, SerializationService serializationService, Data dataKey, HDRecord record, ExpiryMetadata expiryMetadata) {
            super(slot);
            this.dataKey = dataKey;
            this.record = record;
            this.serializationService = serializationService;
            this.expiryMetadata = expiryMetadata;
        }

        public Data getDataKey() {
            return this.dataKey;
        }

        public Record getRecord() {
            return this.record;
        }

        private void ensureCallingFromPartitionOperationThread() {
            if (Thread.currentThread().getClass() != PartitionOperationThread.class) {
                throw new IllegalThreadStateException(Thread.currentThread() + " cannot access data!");
            }
        }

        @Override
        public K getKey() {
            this.ensureCallingFromPartitionOperationThread();
            if (this.key == null) {
                this.key = this.serializationService.toObject(this.dataKey);
            }
            return this.key;
        }

        @Override
        public V getValue() {
            this.ensureCallingFromPartitionOperationThread();
            if (this.value == null) {
                this.value = this.serializationService.toObject(this.record.getValue());
            }
            return this.value;
        }

        @Override
        public long getCost() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getCost();
        }

        @Override
        public long getCreationTime() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getCreationTime();
        }

        @Override
        public long getExpirationTime() {
            this.ensureCallingFromPartitionOperationThread();
            return this.expiryMetadata.getExpirationTime();
        }

        @Override
        public long getHits() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getHits();
        }

        @Override
        public long getLastAccessTime() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getLastAccessTime();
        }

        @Override
        public long getLastStoredTime() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getLastStoredTime();
        }

        @Override
        public long getLastUpdateTime() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getLastUpdateTime();
        }

        @Override
        public long getVersion() {
            this.ensureCallingFromPartitionOperationThread();
            return this.record.getVersion();
        }

        @Override
        public long getTtl() {
            this.ensureCallingFromPartitionOperationThread();
            return this.expiryMetadata.getTtl();
        }

        @Override
        public long getMaxIdle() {
            this.ensureCallingFromPartitionOperationThread();
            return this.expiryMetadata.getMaxIdle();
        }

        public boolean equals(Object o) {
            this.ensureCallingFromPartitionOperationThread();
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntryView)) {
                return false;
            }
            EntryView that = (EntryView)o;
            return this.getKey().equals(that.getKey()) && this.getValue().equals(that.getValue()) && this.getVersion() == that.getVersion() && this.getCost() == that.getCost() && this.getCreationTime() == that.getCreationTime() && this.getExpirationTime() == that.getExpirationTime() && this.getHits() == that.getHits() && this.getLastAccessTime() == that.getLastAccessTime() && this.getLastStoredTime() == that.getLastStoredTime() && this.getLastUpdateTime() == that.getLastUpdateTime() && this.getTtl() == that.getTtl();
        }

        public int hashCode() {
            this.ensureCallingFromPartitionOperationThread();
            int result = super.hashCode();
            result = 31 * result + this.getKey().hashCode();
            result = 31 * result + this.getValue().hashCode();
            long cost = this.getCost();
            long creationTime = this.getCreationTime();
            long expirationTime = this.getExpirationTime();
            long hits = this.getHits();
            long lastAccessTime = this.getLastAccessTime();
            long lastStoredTime = this.getLastStoredTime();
            long lastUpdateTime = this.getLastUpdateTime();
            long version = this.getVersion();
            long ttl = this.getTtl();
            result = 31 * result + (int)(cost ^ cost >>> 32);
            result = 31 * result + (int)(creationTime ^ creationTime >>> 32);
            result = 31 * result + (int)(expirationTime ^ expirationTime >>> 32);
            result = 31 * result + (int)(hits ^ hits >>> 32);
            result = 31 * result + (int)(lastAccessTime ^ lastAccessTime >>> 32);
            result = 31 * result + (int)(lastStoredTime ^ lastStoredTime >>> 32);
            result = 31 * result + (int)(lastUpdateTime ^ lastUpdateTime >>> 32);
            result = 31 * result + (int)(version ^ version >>> 32);
            result = 31 * result + (int)(ttl ^ ttl >>> 32);
            return result;
        }

        public String toString() {
            this.ensureCallingFromPartitionOperationThread();
            return "EntryView{key=" + this.getKey() + ", value=" + this.getValue() + ", cost=" + this.getCost() + ", version=" + this.getVersion() + ", creationTime=" + this.getCreationTime() + ", expirationTime=" + this.getExpirationTime() + ", hits=" + this.getHits() + ", lastAccessTime=" + this.getLastAccessTime() + ", lastStoredTime=" + this.getLastStoredTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", ttl=" + this.getTtl() + '}';
        }
    }
}

