/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.DefaultHiDensityRecordProcessor;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.NativeMapEntryCostEstimator;
import com.hazelcast.map.impl.OwnedEntryCostEstimatorFactory;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.recordstore.ForcedEvictable;
import com.hazelcast.map.impl.recordstore.HDStorageSCHM;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import java.util.Iterator;
import java.util.Map;

public class HDStorageImpl
implements Storage<Data, HDRecord>,
ForcedEvictable<Data, HDRecord> {
    private final HDStorageSCHM map;
    private final HiDensityStorageInfo storageInfo;
    private final HiDensityRecordProcessor recordProcessor;
    private final EntryCostEstimator<NativeMemoryData, MemoryBlock> entryCostEstimator;
    private volatile int entryCount;

    public HDStorageImpl(HiDensityRecordProcessor<HDRecord> recordProcessor, boolean statsEnabled, ExpirySystem expirySystem, SerializationService serializationService) {
        this.recordProcessor = recordProcessor;
        this.storageInfo = ((DefaultHiDensityRecordProcessor)recordProcessor).getStorageInfo();
        this.entryCostEstimator = statsEnabled ? new NativeMapEntryCostEstimator(recordProcessor) : OwnedEntryCostEstimatorFactory.ZERO_SIZE_ESTIMATOR;
        this.map = new HDStorageSCHM(recordProcessor, expirySystem, serializationService);
    }

    public HiDensityRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }

    @Override
    public void removeRecord(Data dataKey, HDRecord record) {
        if (record == null) {
            return;
        }
        NativeMemoryData internalHDKey = this.toBackingDataKeyFormat(dataKey);
        HDRecord oldRecord = (HDRecord)this.map.removeInternal(internalHDKey, false);
        this.addDeferredDispose(internalHDKey);
        this.addDeferredDispose(oldRecord);
        long entryCost = this.entryCostEstimator.calculateEntryCost(internalHDKey, record);
        this.entryCostEstimator.adjustEstimateBy(-entryCost);
        this.storageInfo.decreaseEntryCount();
        this.setEntryCount(this.map.size());
    }

    @Override
    public boolean containsKey(Data key) {
        return this.map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Data key, HDRecord record) {
        block8: {
            NativeMemoryData nativeKey;
            block7: {
                HDRecord oldRecord = null;
                nativeKey = null;
                boolean succeed = false;
                try {
                    nativeKey = this.toNative(key);
                    oldRecord = this.map.put(nativeKey, record);
                    succeed = true;
                    if (!succeed) break block7;
                    this.addDeferredDispose(oldRecord);
                    if (oldRecord != null) {
                        this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(oldRecord));
                        this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateValueCost(record));
                        break block8;
                    }
                    this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateEntryCost(nativeKey, record));
                    this.storageInfo.increaseEntryCount();
                }
                catch (Throwable throwable) {
                    if (succeed) {
                        this.addDeferredDispose(oldRecord);
                        if (oldRecord != null) {
                            this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(oldRecord));
                            this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateValueCost(record));
                        } else {
                            this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateEntryCost(nativeKey, record));
                            this.storageInfo.increaseEntryCount();
                        }
                    } else {
                        this.addDeferredDispose(record);
                        this.addDeferredDispose(nativeKey);
                        this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateEntryCost(nativeKey, record));
                    }
                    throw throwable;
                }
                break block8;
            }
            this.addDeferredDispose(record);
            this.addDeferredDispose(nativeKey);
            this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateEntryCost(nativeKey, record));
        }
        this.setEntryCount(this.map.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HDRecord updateRecordValue(Data key, HDRecord record, Object newValue) {
        long oldCostEstimate;
        NativeMemoryData oldValue;
        boolean disposeNewValue;
        NativeMemoryData newNativeValue;
        block6: {
            newNativeValue = null;
            disposeNewValue = true;
            try {
                oldValue = (NativeMemoryData)record.getValue();
                oldCostEstimate = this.entryCostEstimator.calculateValueCost(record);
                newNativeValue = (NativeMemoryData)this.toNative(newValue);
                if (oldValue == null || newNativeValue == null || oldValue.address() != newNativeValue.address()) break block6;
                disposeNewValue = false;
                HDRecord hDRecord = record;
                if (disposeNewValue) {
                    this.addDeferredDispose(newNativeValue);
                    this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(newNativeValue));
                }
                return hDRecord;
            }
            catch (Throwable throwable) {
                if (disposeNewValue) {
                    this.addDeferredDispose(newNativeValue);
                    this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(newNativeValue));
                }
                throw throwable;
            }
        }
        long address = newValue == null ? 0L : newNativeValue.address();
        record.setValueAddress(address);
        disposeNewValue = false;
        this.addDeferredDispose(oldValue);
        this.entryCostEstimator.adjustEstimateBy(-oldCostEstimate);
        this.entryCostEstimator.adjustEstimateBy(this.entryCostEstimator.calculateValueCost(record));
        if (disposeNewValue) {
            this.addDeferredDispose(newNativeValue);
            this.entryCostEstimator.adjustEstimateBy(-this.entryCostEstimator.calculateValueCost(newNativeValue));
        }
        return record;
    }

    @Override
    public HDRecord get(Data key) {
        return (HDRecord)this.map.get(key);
    }

    @Override
    public HDRecord getIfSameKey(Data key) {
        return (HDRecord)this.map.getIfSameKey(key);
    }

    @Override
    public void clear(boolean isDuringShutdown) {
        HazelcastMemoryManager memoryManager = ((DefaultHiDensityRecordProcessor)this.recordProcessor).getMemoryManager();
        if (memoryManager == null || memoryManager.isDisposed()) {
            return;
        }
        long entryCount = this.map.size();
        this.map.clear();
        this.setEntryCount(0);
        this.storageInfo.removeEntryCount(entryCount);
        this.entryCostEstimator.reset();
    }

    private void setEntryCount(int value) {
        this.entryCount = value;
    }

    @Override
    public Iterator<Map.Entry<Data, HDRecord>> mutationTolerantIterator() {
        return IterableUtil.asReadOnlyIterator(this.map.cachedEntryIter(false));
    }

    @Override
    public Iterator<Map.Entry<Data, HDRecord>> newRandomEvictionEntryIterator() {
        return this.map.newRandomEvictionCachedEntryIterator();
    }

    @Override
    public int size() {
        return this.entryCount;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void destroy(boolean isDuringShutdown) {
        HazelcastMemoryManager memoryManager = ((DefaultHiDensityRecordProcessor)this.recordProcessor).getMemoryManager();
        if (memoryManager == null || memoryManager.isDisposed()) {
            return;
        }
        long entryCount = this.map.size();
        this.disposeDeferredBlocks();
        this.map.dispose();
        this.setEntryCount(0);
        this.storageInfo.removeEntryCount(entryCount);
        this.entryCostEstimator.reset();
    }

    @Override
    public EntryCostEstimator getEntryCostEstimator() {
        return this.entryCostEstimator;
    }

    @Override
    public void setEntryCostEstimator(EntryCostEstimator entryCostEstimator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disposeDeferredBlocks() {
        this.recordProcessor.disposeDeferredBlocks();
    }

    private void addDeferredDispose(Object memoryBlock) {
        if (memoryBlock == null || memoryBlock instanceof HeapData || !(memoryBlock instanceof MemoryBlock) || ((MemoryBlock)memoryBlock).address() == 0L) {
            return;
        }
        this.recordProcessor.addDeferredDispose((MemoryBlock)memoryBlock);
    }

    protected NativeMemoryData toNative(Data key) {
        return (NativeMemoryData)this.recordProcessor.convertData(key, DataType.NATIVE);
    }

    private Data toNative(Object value) {
        return this.recordProcessor.toData(value, DataType.NATIVE);
    }

    @Override
    public Iterable getRandomSamples(int sampleCount) {
        return this.map.getRandomSamples(sampleCount);
    }

    @Override
    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        return this.map.fetchKeys(pointers, size);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        return this.map.fetchEntries(pointers, size);
    }

    @Override
    public Data extractDataKeyFromLazy(EntryView entryView) {
        return ((HDStorageSCHM.LazyEvictableEntryView)entryView).getDataKey();
    }

    @Override
    public NativeMemoryData toBackingDataKeyFormat(Data key) {
        long address = this.getNativeKeyAddress(key);
        return new NativeMemoryData().reset(address);
    }

    public long getNativeKeyAddress(Data key) {
        return this.map.getNativeKeyAddress(key);
    }
}

